/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import com.wordnik.swagger.core.SwaggerSpec;
import com.wordnik.swagger.core.util.JsonSerializer;
import com.wordnik.swagger.model.AllowableListValues;
import com.wordnik.swagger.model.AllowableValues;
import com.wordnik.swagger.model.ApiDescription;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.Operation;
import com.wordnik.swagger.model.Parameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.engine.Engine;
import org.restlet.engine.connector.ConnectorHelper;
import org.restlet.engine.io.IoUtils;
import org.restlet.ext.swagger.ApplicationInfo;
import org.restlet.ext.swagger.DocumentationInfo;
import org.restlet.ext.swagger.MethodInfo;
import org.restlet.ext.swagger.ParameterInfo;
import org.restlet.ext.swagger.RepresentationInfo;
import org.restlet.ext.swagger.ResourceInfo;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.immutable.HashMap;

public class SwaggerRepresentation
extends OutputRepresentation {
    private ApplicationInfo application;
    private ApiListing apiListing;

    public SwaggerRepresentation() {
        super(MediaType.APPLICATION_JSON);
    }

    public SwaggerRepresentation(ApplicationInfo application) {
        super(MediaType.APPLICATION_JSON);
        ArrayList<String> protocols = new ArrayList<String>();
        for (ConnectorHelper helper : Engine.getInstance().getRegisteredServers()) {
            for (Protocol protocol : helper.getProtocols()) {
                if (protocols.contains(protocol.getName())) continue;
                protocols.add(protocol.getName());
            }
        }
        ArrayList<String> produces = new ArrayList<String>();
        ArrayList<String> consumes = new ArrayList<String>();
        for (RepresentationInfo ri : application.getRepresentations()) {
            produces.add(ri.getMediaType().getName());
            consumes.add(ri.getMediaType().getName());
        }
        ArrayList authorizations = new ArrayList();
        ArrayList<ApiDescription> apis = new ArrayList<ApiDescription>();
        for (ResourceInfo ri : application.getResources().getResources()) {
            ArrayList<Operation> ops = new ArrayList<Operation>();
            int i = 0;
            for (MethodInfo mi : ri.getMethods()) {
                ArrayList<Parameter> params = new ArrayList<Parameter>();
                if (mi.getRequest() != null && mi.getRequest().getParameters() != null) {
                    for (ParameterInfo pi : mi.getRequest().getParameters()) {
                        Parameter param = new Parameter(pi.getName(), Option.apply((Object)this.toString(pi.getDocumentations())), Option.apply((Object)pi.getDefaultValue()), true, true, pi.getType(), (AllowableValues)new AllowableListValues(null, pi.getType()), pi.getStyle().name(), Option.apply((Object)"paramAccess"));
                        params.add(param);
                    }
                }
                ArrayList liste = new ArrayList();
                Operation op = new Operation(mi.getName().getName(), this.toString(mi.getDocumentations()), "", "", mi.getIdentifier(), i, JavaConversions.asScalaIterable(consumes).toList(), JavaConversions.asScalaIterable(consumes).toList(), JavaConversions.asScalaIterable(protocols).toList(), JavaConversions.asScalaIterable(authorizations).toList(), JavaConversions.asScalaIterable(params).toList(), JavaConversions.asScalaIterable(liste).toList(), Option.apply((Object)""));
                ops.add(op);
                ++i;
            }
            apis.add(new ApiDescription(ri.getPath(), Option.apply((Object)this.toString(ri.getDocumentations())), JavaConversions.asScalaIterable(ops).toList()));
        }
        java.util.HashMap models = new java.util.HashMap();
        HashMap pouet = new HashMap();
        Option truc = Option.apply((Object)pouet);
        this.apiListing = new ApiListing(application.getVersion(), SwaggerSpec.version(), application.getResources().getBaseRef().toString(), application.getResources().getBaseRef().toString(), JavaConversions.asScalaIterable(consumes).toList(), JavaConversions.asScalaIterable(produces).toList(), JavaConversions.asScalaIterable(protocols).toList(), JavaConversions.asScalaIterable(authorizations).toList(), JavaConversions.asScalaIterable(apis).toList(), truc, Option.apply((Object)this.toString(application.getDocumentations())), 0);
        this.application = application;
    }

    private String toString(List<DocumentationInfo> di) {
        StringBuilder d = new StringBuilder();
        for (DocumentationInfo doc : di) {
            d.append(doc.getTextContent());
        }
        return d.toString();
    }

    public SwaggerRepresentation(ApiListing apiListing) {
        super(MediaType.APPLICATION_JSON);
        this.application = this.application;
    }

    public SwaggerRepresentation(ResourceInfo resource) {
        super(MediaType.APPLICATION_JSON);
        this.application = resource.createApplication();
    }

    public ApplicationInfo getApplication() {
        return this.application;
    }

    public Representation getHtmlRepresentation() {
        Representation representation = null;
        return representation;
    }

    public InputStream getStream() throws IOException {
        return new ByteArrayInputStream(JsonSerializer.asJson((Object)this.apiListing).getBytes());
    }

    public void setApplication(ApplicationInfo application) {
        this.application = application;
    }

    public void write(OutputStream outputStream) throws IOException {
        Writer writer = IoUtils.getWriter((OutputStream)outputStream, (CharacterSet)this.getCharacterSet());
        this.write(writer);
        writer.flush();
    }

    public void write(Writer writer) throws IOException {
        if (this.apiListing != null) {
            writer.write(JsonSerializer.asJson((Object)this.apiListing));
            writer.flush();
        }
    }
}

