/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.SwaggerSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.Path;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.ext.jaxrs.JaxRsRestlet;
import org.restlet.ext.swagger.internal.SwaggerJaxRsResourceGenerator;
import org.restlet.ext.swagger.internal.SwaggerRestletIterable;
import org.restlet.representation.Representation;
import org.restlet.routing.Filter;

public class SwaggerUiRestlet
extends Restlet {
    Restlet apiInboundRoot;
    private String apiVersion;
    private String basePath;
    private String jsonPath;
    private String swaggerVersion = SwaggerSpec.version();

    public SwaggerUiRestlet() {
        this(null);
    }

    public SwaggerUiRestlet(Context context) {
        super(context);
    }

    private Class<?> findJaxRsClass(JaxRsRestlet jaxRsRestlet, String path) {
        Set classes = jaxRsRestlet.getRootResourceClasses();
        for (Class clazz : classes) {
            Api apiAnnotation = clazz.getAnnotation(Api.class);
            if (apiAnnotation == null) continue;
            if (apiAnnotation.value() == null || apiAnnotation.value().isEmpty()) {
                if (path != null && !path.isEmpty()) continue;
                return clazz;
            }
            if (apiAnnotation.value().equals(path)) {
                return clazz;
            }
            if (!(apiAnnotation.value().startsWith("/") ? apiAnnotation.value().substring(1).equals(path) : apiAnnotation.value().equals(path.substring(1)))) continue;
            return clazz;
        }
        return null;
    }

    private JaxRsRestlet getNextJaxRsRestlet(Restlet restlet) {
        if (restlet instanceof JaxRsRestlet) {
            return (JaxRsRestlet)restlet;
        }
        if (restlet instanceof Filter) {
            return this.getNextJaxRsRestlet(((Filter)restlet).getNext());
        }
        return null;
    }

    public void handle(Request request, Response response) {
        super.handle(request, response);
        String baseRef = request.getResourceRef().getBaseRef().toString(false, false);
        String resourcePath = request.getResourceRef().toString(false, false).substring(baseRef.length());
        if (resourcePath.isEmpty() || resourcePath.equals("/")) {
            Documentation documentation = new Documentation();
            documentation.setApiVersion(this.apiVersion);
            documentation.setSwaggerVersion(this.swaggerVersion);
            documentation.setBasePath(this.basePath);
            SwaggerRestletIterable crawler = new SwaggerRestletIterable(this.apiInboundRoot);
            for (Restlet restlet : crawler) {
                JaxRsRestlet jaxRsRestlet = this.getNextJaxRsRestlet(restlet);
                if (restlet == null) continue;
                Collection<DocumentationEndPoint> endPoints = this.scan(jaxRsRestlet, crawler.getCurrentPath());
                for (DocumentationEndPoint endPoint : endPoints) {
                    if (endPoint.getPath() != null) {
                        if (this.jsonPath != null) {
                            if (this.jsonPath.endsWith("/")) {
                                if (endPoint.getPath() != null && endPoint.getPath().startsWith("/")) {
                                    endPoint.setPath(this.jsonPath + endPoint.getPath().substring(1));
                                } else {
                                    endPoint.setPath(this.jsonPath + endPoint.getPath());
                                }
                            } else if (endPoint.getPath() != null && endPoint.getPath().startsWith("/")) {
                                endPoint.setPath(this.jsonPath + endPoint.getPath());
                            } else {
                                endPoint.setPath(this.jsonPath + "/" + endPoint.getPath());
                            }
                        } else {
                            endPoint.setPath(endPoint.getPath());
                        }
                    } else if (this.jsonPath != null) {
                        endPoint.setPath(this.jsonPath);
                    }
                    documentation.addApi(endPoint);
                }
            }
            response.setEntity((Representation)new JacksonRepresentation((Object)documentation));
            return;
        }
        SwaggerRestletIterable crawler = new SwaggerRestletIterable(this.apiInboundRoot);
        for (Restlet restlet : crawler) {
            Class<?> clazz;
            JaxRsRestlet jaxRsRestlet = this.getNextJaxRsRestlet(restlet);
            if (restlet == null || (clazz = this.findJaxRsClass(jaxRsRestlet, resourcePath)) == null) continue;
            SwaggerJaxRsResourceGenerator generator = new SwaggerJaxRsResourceGenerator();
            generator.setup(clazz, crawler.getCurrentPath());
            Documentation documentation = generator.parse();
            documentation.setApiVersion(this.apiVersion);
            documentation.setSwaggerVersion(this.swaggerVersion);
            documentation.setBasePath(this.basePath);
            documentation.setResourcePath(resourcePath);
            response.setEntity((Representation)new JacksonRepresentation((Object)documentation));
            return;
        }
        response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
    }

    private Collection<DocumentationEndPoint> scan(JaxRsRestlet jaxRsRestlet, String path) {
        ArrayList<DocumentationEndPoint> retVal = new ArrayList<DocumentationEndPoint>();
        Set classes = jaxRsRestlet.getRootResourceClasses();
        for (Class clazz : classes) {
            Api apiAnnotation = clazz.getAnnotation(Api.class);
            Path pathAnnotation = clazz.getAnnotation(Path.class);
            if (apiAnnotation == null || pathAnnotation == null) continue;
            DocumentationEndPoint ep = new DocumentationEndPoint(apiAnnotation.value(), apiAnnotation.description());
            retVal.add(ep);
        }
        return retVal;
    }

    public void setApiInboundRoot(Application application) {
        if (application != null) {
            this.apiInboundRoot = application.getInboundRoot();
        }
    }

    public void setApiInboundRoot(Restlet apiInboundRoot) {
        this.apiInboundRoot = apiInboundRoot;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public void setSwaggerVersion(String swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }
}

