/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger.internal;

import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiParamImplicit;
import com.wordnik.swagger.annotations.ApiParamsImplicit;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.DocumentationError;
import com.wordnik.swagger.core.DocumentationObject;
import com.wordnik.swagger.core.DocumentationOperation;
import com.wordnik.swagger.core.DocumentationParameter;
import com.wordnik.swagger.core.DocumentationSchema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.restlet.ext.swagger.internal.SwaggerUtils;

public class SwaggerJaxRsResourceGenerator {
    private Map<String, DocumentationEndPoint> apis = new HashMap<String, DocumentationEndPoint>();
    private Documentation documentation = new Documentation();
    private Class<?> jaxRsClass;
    private Map<String, DocumentationSchema> models = new HashMap<String, DocumentationSchema>();
    private String resourcePath;

    private void addApiParamImplicit(List<DocumentationParameter> retVal, ApiParamImplicit implicitParam) {
        if (null == implicitParam) {
            return;
        }
        DocumentationParameter documentationParameter = new DocumentationParameter();
        documentationParameter.setAllowMultiple(implicitParam.allowMultiple());
        documentationParameter.setDataType(implicitParam.dataType());
        documentationParameter.setDefaultValue(implicitParam.defaultValue());
        documentationParameter.setInternalDescription(implicitParam.internalDescription());
        documentationParameter.setName(implicitParam.name());
        documentationParameter.setParamType(implicitParam.paramType());
        documentationParameter.setRequired(implicitParam.required());
        retVal.add(documentationParameter);
    }

    private void addParam(List<DocumentationParameter> retVal, String name, String type, Class<?> parameterType, ApiParam apiParam) {
        DocumentationParameter documentationParameter = new DocumentationParameter();
        if (apiParam != null) {
            documentationParameter.setAllowMultiple(apiParam.allowMultiple());
            documentationParameter.setDataType(parameterType.getSimpleName());
            documentationParameter.setDefaultValue(apiParam.defaultValue());
            documentationParameter.setInternalDescription(apiParam.internalDescription());
            documentationParameter.setName(apiParam.name());
            documentationParameter.setRequired(apiParam.required());
        }
        documentationParameter.setName(name);
        documentationParameter.setParamType(type);
        retVal.add(documentationParameter);
    }

    private DocumentationEndPoint getApi(String methodPath) {
        DocumentationEndPoint endPoint = this.apis.get(methodPath = SwaggerUtils.leaveOnlyPathParamNames(methodPath));
        if (endPoint == null) {
            endPoint = new DocumentationEndPoint();
            endPoint.setPath(methodPath);
            this.apis.put(methodPath, endPoint);
        }
        return endPoint;
    }

    private DocumentationError getDocumentationError(ApiError apiErrorAnnotation) {
        if (apiErrorAnnotation == null) {
            return null;
        }
        DocumentationError error = new DocumentationError();
        error.setCode(apiErrorAnnotation.code());
        error.setReason(apiErrorAnnotation.reason());
        return error;
    }

    public Documentation parse() {
        for (Method method : this.jaxRsClass.getMethods()) {
            this.processMethod(method, GET.class);
            this.processMethod(method, PUT.class);
            this.processMethod(method, POST.class);
            this.processMethod(method, DELETE.class);
            this.processMethod(method, HEAD.class);
        }
        for (Map.Entry<String, DocumentationEndPoint> entry : this.apis.entrySet()) {
            DocumentationEndPoint ep = entry.getValue();
            this.documentation.addApi(ep);
        }
        for (Map.Entry<String, DocumentationEndPoint> entry : this.models.entrySet()) {
            this.documentation.addModel(entry.getKey(), (DocumentationSchema)entry.getValue());
        }
        return this.documentation;
    }

    private List<DocumentationParameter> parseParameters(Method method) {
        ArrayList<DocumentationParameter> retVal = new ArrayList<DocumentationParameter>();
        ApiParamsImplicit implicitParams = method.getAnnotation(ApiParamsImplicit.class);
        if (implicitParams != null) {
            for (ApiParamImplicit implicitParam : implicitParams.value()) {
                this.addApiParamImplicit(retVal, implicitParam);
            }
        }
        ApiParamImplicit implicitParam = method.getAnnotation(ApiParamImplicit.class);
        this.addApiParamImplicit(retVal, implicitParam);
        Class<?>[] parameterTypes = method.getParameterTypes();
        int cnt = 0;
        for (Annotation[] annotation : method.getParameterAnnotations()) {
            this.processJaxRsParam(retVal, annotation, parameterTypes[cnt++]);
        }
        return retVal;
    }

    private void processJaxRsParam(List<DocumentationParameter> retVal, Annotation[] parameterAnnotations, Class<?> parameterType) {
        ApiParam apiParam = null;
        String name = null;
        String type = null;
        for (Annotation annotation : parameterAnnotations) {
            if (annotation instanceof ApiParam) {
                apiParam = (ApiParam)annotation;
            }
            if (annotation instanceof PathParam) {
                PathParam annoPath = (PathParam)annotation;
                type = "path";
                name = annoPath.value();
            }
            if (annotation instanceof HeaderParam) {
                HeaderParam annoHeader = (HeaderParam)annotation;
                type = "header";
                name = annoHeader.value();
            }
            if (annotation instanceof QueryParam) {
                QueryParam annoQuery = (QueryParam)annotation;
                type = "query";
                name = annoQuery.value();
            }
            if (annotation instanceof CookieParam) {
                CookieParam annoCookie = (CookieParam)annotation;
                type = "cookie";
                name = annoCookie.value();
            }
            if (annotation instanceof FormParam) {
                FormParam annoForm = (FormParam)annotation;
                type = "form";
                name = annoForm.value();
            }
            if (!(annotation instanceof MatrixParam)) continue;
            MatrixParam annoMatrix = (MatrixParam)annotation;
            type = "matrix";
            name = annoMatrix.value();
        }
        if (name != null) {
            this.addParam(retVal, name, type, parameterType, apiParam);
        }
    }

    private void processMethod(Method method, Class httpMethodClass) {
        String methodPath = this.resourcePath;
        Path pathAnnotation = method.getAnnotation(Path.class);
        if (pathAnnotation != null) {
            methodPath = methodPath + pathAnnotation.value() + "/";
        }
        methodPath = SwaggerUtils.cleanSlashes(methodPath);
        Object httpMthodAnnotation = method.getAnnotation(httpMethodClass);
        ApiOperation apiOperationAnnotation = method.getAnnotation(ApiOperation.class);
        if (httpMthodAnnotation != null && apiOperationAnnotation != null) {
            Class<?> returnType;
            DocumentationError error;
            DocumentationEndPoint endPoint = this.getApi(methodPath);
            DocumentationOperation op = new DocumentationOperation();
            op.setHttpMethod(httpMthodAnnotation.annotationType().getSimpleName());
            op.setSummary(apiOperationAnnotation.value());
            op.setNotes(apiOperationAnnotation.notes());
            op.setTags(SwaggerUtils.toList(apiOperationAnnotation.tags()));
            op.setNickname(method.getName());
            ApiErrors apiErrors = method.getAnnotation(ApiErrors.class);
            if (apiErrors != null) {
                for (ApiError apiError : apiErrors.value()) {
                    DocumentationError error2 = this.getDocumentationError(apiError);
                    if (error2 == null) continue;
                    op.addErrorResponse(error2);
                }
            }
            if ((error = this.getDocumentationError(method.getAnnotation(ApiError.class))) != null) {
                op.addErrorResponse(error);
            }
            if ((returnType = method.getReturnType()) != null) {
                op.setResponseClass(returnType.getSimpleName());
                if (!returnType.isPrimitive()) {
                    DocumentationObject documentationObject = new DocumentationObject();
                    this.models.put(returnType.getSimpleName(), documentationObject.toDocumentationSchema());
                }
            }
            op.setParameters(this.parseParameters(method));
            endPoint.addOperation(op);
            endPoint.setDescription(apiOperationAnnotation.value());
        }
    }

    public void setup(Class<?> jaxRsClass, String resourcePath) {
        this.resourcePath = resourcePath;
        this.jaxRsClass = jaxRsClass;
    }
}

