/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.Path;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.ext.jaxrs.JaxRsRestlet;
import org.restlet.ext.swagger.SwaggerSpecificationRestlet;
import org.restlet.ext.swagger.internal.SwaggerJaxRsResourceGenerator;
import org.restlet.ext.swagger.internal.SwaggerRestletIterable;
import org.restlet.representation.Representation;
import org.restlet.routing.Filter;

public class JaxrsSwaggerSpecificationRestlet
extends SwaggerSpecificationRestlet {
    public JaxrsSwaggerSpecificationRestlet() {
        this(null);
    }

    public JaxrsSwaggerSpecificationRestlet(Context context) {
        super(context);
    }

    private Class<?> findJaxRsClass(JaxRsRestlet jaxRsRestlet, String path) {
        Set classes = jaxRsRestlet.getRootResourceClasses();
        for (Class clazz : classes) {
            Api apiAnnotation = clazz.getAnnotation(Api.class);
            if (apiAnnotation == null) continue;
            if (apiAnnotation.value() == null || apiAnnotation.value().isEmpty()) {
                if (path != null && !path.isEmpty()) continue;
                return clazz;
            }
            if (apiAnnotation.value().equals(path)) {
                return clazz;
            }
            if (!(apiAnnotation.value().startsWith("/") ? apiAnnotation.value().substring(1).equals(path) : apiAnnotation.value().equals(path.substring(1)))) continue;
            return clazz;
        }
        return null;
    }

    @Override
    public Representation getApiDeclaration(String resourcePath) {
        Documentation documentation = null;
        SwaggerRestletIterable crawler = new SwaggerRestletIterable(this.apiInboundRoot);
        for (Restlet restlet : crawler) {
            Class<?> clazz;
            JaxRsRestlet jaxRsRestlet = this.getNextJaxRsRestlet(restlet);
            if (restlet == null || (clazz = this.findJaxRsClass(jaxRsRestlet, resourcePath)) == null) continue;
            SwaggerJaxRsResourceGenerator generator = new SwaggerJaxRsResourceGenerator();
            generator.setup(clazz, crawler.getCurrentPath());
            documentation = generator.parse();
            documentation.setApiVersion(this.getApiVersion());
            documentation.setSwaggerVersion(this.getSwaggerVersion());
            documentation.setBasePath(this.getBasePath());
            documentation.setResourcePath(resourcePath);
            break;
        }
        return new JacksonRepresentation(documentation);
    }

    private JaxRsRestlet getNextJaxRsRestlet(Restlet restlet) {
        if (restlet instanceof JaxRsRestlet) {
            return (JaxRsRestlet)restlet;
        }
        if (restlet instanceof Filter) {
            return this.getNextJaxRsRestlet(((Filter)restlet).getNext());
        }
        return null;
    }

    @Override
    public Representation getResourceListing() {
        Documentation documentation = new Documentation();
        documentation.setApiVersion(this.getApiVersion());
        documentation.setSwaggerVersion(this.getSwaggerVersion());
        documentation.setBasePath(this.getBasePath());
        SwaggerRestletIterable crawler = new SwaggerRestletIterable(this.apiInboundRoot);
        for (Restlet restlet : crawler) {
            JaxRsRestlet jaxRsRestlet = this.getNextJaxRsRestlet(restlet);
            if (restlet == null) continue;
            Collection<DocumentationEndPoint> endPoints = this.scan(jaxRsRestlet, crawler.getCurrentPath());
            for (DocumentationEndPoint endPoint : endPoints) {
                if (endPoint.getPath() != null) {
                    if (this.getJsonPath() != null) {
                        if (this.getJsonPath().endsWith("/")) {
                            if (endPoint.getPath() != null && endPoint.getPath().startsWith("/")) {
                                endPoint.setPath(this.getJsonPath() + endPoint.getPath().substring(1));
                            } else {
                                endPoint.setPath(this.getJsonPath() + endPoint.getPath());
                            }
                        } else if (endPoint.getPath() != null && endPoint.getPath().startsWith("/")) {
                            endPoint.setPath(this.getJsonPath() + endPoint.getPath());
                        } else {
                            endPoint.setPath(this.getJsonPath() + "/" + endPoint.getPath());
                        }
                    } else {
                        endPoint.setPath(endPoint.getPath());
                    }
                } else if (this.getJsonPath() != null) {
                    endPoint.setPath(this.getJsonPath());
                }
                documentation.addApi(endPoint);
            }
        }
        return new JacksonRepresentation((Object)documentation);
    }

    private Collection<DocumentationEndPoint> scan(JaxRsRestlet jaxRsRestlet, String path) {
        ArrayList<DocumentationEndPoint> retVal = new ArrayList<DocumentationEndPoint>();
        Set classes = jaxRsRestlet.getRootResourceClasses();
        for (Class clazz : classes) {
            Api apiAnnotation = clazz.getAnnotation(Api.class);
            Path pathAnnotation = clazz.getAnnotation(Path.class);
            if (apiAnnotation == null || pathAnnotation == null) continue;
            DocumentationEndPoint ep = new DocumentationEndPoint(apiAnnotation.value(), apiAnnotation.description());
            retVal.add(ep);
        }
        return retVal;
    }
}

