/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Header;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.conversion.SwaggerTranslator;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.ext.swagger.internal.reflect.Introspector;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class SwaggerSpecificationRestlet
extends Restlet {
    Restlet apiInboundRoot;
    private String apiVersion;
    Application application;
    private String basePath;
    private Definition definition;
    private String jsonPath;
    private String swaggerVersion = "1.2";

    public SwaggerSpecificationRestlet() {
        this(null);
    }

    public SwaggerSpecificationRestlet(Context context) {
        super(context);
    }

    public Representation getApiDeclaration(String category) {
        return new JacksonRepresentation((Object)SwaggerTranslator.getApiDeclaration((String)category, (Definition)this.getDefinition()));
    }

    public Restlet getApiInboundRoot() {
        if (this.apiInboundRoot == null && this.application != null) {
            this.apiInboundRoot = this.application.getInboundRoot();
        }
        return this.apiInboundRoot;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getBasePath() {
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Definition getDefinition() {
        if (this.definition != null) return this.definition;
        Class<SwaggerSpecificationRestlet> clazz = SwaggerSpecificationRestlet.class;
        synchronized (SwaggerSpecificationRestlet.class) {
            Introspector i = new Introspector(this.application, false);
            this.definition = i.getDefinition();
            if (this.definition.getVersion() == null) {
                this.definition.setVersion("1.0");
            }
            if (this.definition.getEndpoint() != null) return this.definition;
            this.definition.setEndpoint("http://localhost:9000/v1");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.definition;
        }
    }

    public String getJsonPath() {
        return this.jsonPath;
    }

    public Representation getResourceListing() {
        return new JacksonRepresentation((Object)SwaggerTranslator.getResourcelisting((Definition)this.getDefinition()));
    }

    public String getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public void handle(Request request, Response response) {
        Object resource;
        super.handle(request, response);
        Series headers = new Series(Header.class);
        headers.set("Access-Control-Expose-Headers", "Authorization, Link, X-RateLimit-Limit, X-RateLimit-Remaining, X-OAuth-Scopes, X-Accepted-OAuth-Scopes");
        headers.set("Access-Control-Allow-Headers", "Authorization,");
        headers.set("Access-Control-Allow-Credentials", "true");
        headers.set("Access-Control-Allow-Methods", "GET");
        Series reqHeaders = (Series)request.getAttributes().get("org.restlet.http.headers");
        String requestOrigin = reqHeaders.getFirstValue("Origin", "*");
        headers.set("Access-Control-Allow-Origin", requestOrigin);
        response.getAttributes().put("org.restlet.http.headers", headers);
        if (!Method.GET.equals((Object)request.getMethod())) {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        if ((resource = request.getAttributes().get("resource")) instanceof String) {
            response.setEntity(this.getApiDeclaration((String)resource));
        } else {
            response.setEntity(this.getResourceListing());
        }
    }

    public void setApiInboundRoot(Application application) {
        this.application = application;
    }

    public void setApiInboundRoot(Restlet apiInboundRoot) {
        this.apiInboundRoot = apiInboundRoot;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public void setSwaggerVersion(String swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }
}

