/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger.internal;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.ext.swagger.internal.SwaggerUtils;
import org.restlet.routing.Filter;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;
import org.restlet.util.RouteList;

public class SwaggerRestletIterator
implements Iterator<Restlet> {
    private String currentPath = "/";
    private Map<Restlet, String> toCrawl = new LinkedHashMap<Restlet, String>();

    public SwaggerRestletIterator(Restlet restlet) {
        this.toCrawl.put(restlet, "/");
    }

    private Map<Restlet, String> expand(Restlet restlet, String currentPath) {
        LinkedHashMap<Restlet, String> retVal = new LinkedHashMap<Restlet, String>();
        if (restlet instanceof Filter) {
            Filter filter = (Filter)restlet;
            retVal.put(filter.getNext(), currentPath);
        } else if (restlet instanceof Router) {
            Router router = (Router)restlet;
            RouteList routeList = router.getRoutes();
            for (Route route : routeList) {
                if (!(route instanceof TemplateRoute)) continue;
                TemplateRoute templateRoute = (TemplateRoute)route;
                String templatePattern = templateRoute.getTemplate().getPattern();
                String path = SwaggerUtils.cleanSlashes(currentPath + templatePattern + "/");
                retVal.put(templateRoute.getNext(), path);
            }
        } else if (restlet instanceof Application) {
            Application app = (Application)restlet;
            retVal.put(app.createInboundRoot(), currentPath);
        }
        return retVal;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    @Override
    public boolean hasNext() {
        return !this.toCrawl.isEmpty();
    }

    @Override
    public Restlet next() {
        if (this.toCrawl.isEmpty()) {
            return null;
        }
        Restlet currentRestlet = this.toCrawl.keySet().iterator().next();
        this.currentPath = this.toCrawl.remove(currentRestlet);
        this.toCrawl.putAll(this.expand(currentRestlet, this.currentPath));
        return currentRestlet;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

