/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import java.util.ArrayList;
import java.util.List;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.cors.CorsResponseHelper;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.SwaggerTranslator;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ApiDeclaration;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.model.ResourceListing;
import org.restlet.ext.apispark.internal.introspection.IntrospectionHelper;
import org.restlet.ext.apispark.internal.introspection.application.ApplicationIntrospector;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.routing.Router;

public class SwaggerSpecificationRestlet
extends Restlet {
    private String apiVersion;
    private Application application;
    private String basePath;
    private Reference baseRef;
    private CorsResponseHelper corsResponseHelper = new CorsResponseHelper();
    private Definition definition;
    private List<IntrospectionHelper> introspectionHelpers = new ArrayList<IntrospectionHelper>();
    private String swaggerVersion = "1.2";

    public SwaggerSpecificationRestlet() {
        this(null);
    }

    public SwaggerSpecificationRestlet(Context context) {
        super(context);
    }

    public SwaggerSpecificationRestlet addIntrospectorPlugin(IntrospectionHelper helper) {
        this.introspectionHelpers.add(helper);
        return this;
    }

    public void attach(Router router) {
        this.attach(router, "/api-docs");
    }

    public void attach(Router router, String path) {
        router.attach(path, (Restlet)this);
        router.attach(path + "/{resource}", (Restlet)this);
    }

    public Representation getApiDeclaration(String category) {
        ApiDeclaration apiDeclaration = SwaggerTranslator.getApiDeclaration((String)category, (Definition)this.getDefinition());
        apiDeclaration.setSwaggerVersion(this.swaggerVersion);
        return new JacksonRepresentation((Object)apiDeclaration);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getBasePath() {
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Definition getDefinition() {
        if (this.definition != null) return this.definition;
        Class<SwaggerSpecificationRestlet> clazz = SwaggerSpecificationRestlet.class;
        synchronized (SwaggerSpecificationRestlet.class) {
            this.definition = ApplicationIntrospector.getDefinition((Application)this.application, (Reference)this.baseRef, null, this.introspectionHelpers);
            if (this.definition.getVersion() != null) return this.definition;
            this.definition.setVersion(this.apiVersion != null ? this.apiVersion : "1.0");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.definition;
        }
    }

    public Representation getResourceListing() {
        ResourceListing resourcelisting = SwaggerTranslator.getResourcelisting((Definition)this.getDefinition());
        resourcelisting.setSwaggerVersion(this.swaggerVersion);
        return new JacksonRepresentation((Object)resourcelisting);
    }

    public String getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public void handle(Request request, Response response) {
        super.handle(request, response);
        this.corsResponseHelper.addCorsResponseHeaders(request, response);
        if (Method.GET.equals((Object)request.getMethod())) {
            Object resource = request.getAttributes().get("resource");
            if (resource instanceof String) {
                response.setEntity(this.getApiDeclaration((String)resource));
            } else {
                response.setEntity(this.getResourceListing());
            }
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
    }

    public SwaggerSpecificationRestlet setApiInboundRoot(Application application) {
        this.application = application;
        return this;
    }

    public SwaggerSpecificationRestlet setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public SwaggerSpecificationRestlet setApplication(Application application) {
        this.application = application;
        return this;
    }

    public SwaggerSpecificationRestlet setBasePath(String basePath) {
        this.basePath = basePath;
        this.baseRef = basePath != null ? new Reference(basePath) : null;
        return this;
    }

    public SwaggerSpecificationRestlet setSwaggerVersion(String swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
        return this;
    }
}

