/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wordnik.swagger.models.Swagger;
import javax.ws.rs.core.Application;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.conversion.swagger.v2_0.Swagger2Translator;
import org.restlet.ext.apispark.internal.introspection.jaxrs.JaxRsIntrospector;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.routing.Router;

public class JaxRsApplicationSwagger2SpecificationRestlet
extends Restlet {
    private String apiVersion;
    private Application application;
    private String basePath;
    private Reference baseRef;
    private Definition definition;
    private String swaggerVersion = "2.0";

    public JaxRsApplicationSwagger2SpecificationRestlet() {
    }

    public JaxRsApplicationSwagger2SpecificationRestlet(Application application) {
        this.application = application;
    }

    public void attach(Router router) {
        this.attach(router, "/swagger.json");
    }

    public void attach(Router router, String path) {
        router.attach(path, (Restlet)this);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getBasePath() {
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Definition getDefinition() {
        if (this.definition != null) return this.definition;
        Class<JaxRsApplicationSwagger2SpecificationRestlet> clazz = JaxRsApplicationSwagger2SpecificationRestlet.class;
        synchronized (JaxRsApplicationSwagger2SpecificationRestlet.class) {
            this.definition = JaxRsIntrospector.getDefinition((Application)this.application, (Reference)this.baseRef, (boolean)false);
            if (this.definition.getVersion() != null) return this.definition;
            this.definition.setVersion("1.0");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.definition;
        }
    }

    public Representation getSwagger() {
        Swagger swagger = Swagger2Translator.getSwagger((Definition)this.getDefinition());
        swagger.setSwagger(this.swaggerVersion);
        JacksonRepresentation swaggerJacksonRepresentation = new JacksonRepresentation((Object)swagger);
        ObjectMapper objectMapper = swaggerJacksonRepresentation.getObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return swaggerJacksonRepresentation;
    }

    public String getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (Method.GET.equals((Object)request.getMethod())) {
            response.setEntity(this.getSwagger());
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
        this.baseRef = basePath != null ? new Reference(basePath) : null;
    }

    public void setSwaggerVersion(String swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }
}

