/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.ext.swagger.SwaggerSpecificationRestlet;
import org.restlet.routing.Filter;
import org.restlet.routing.Route;
import org.restlet.routing.Router;

public class SwaggerApplication
extends Application {
    private boolean documented;

    private static Router getNextRouter(Restlet current) {
        Router result = null;
        if (current instanceof Router) {
            result = (Router)current;
        } else if (current instanceof Filter) {
            result = SwaggerApplication.getNextRouter(((Filter)current).getNext());
        }
        return result;
    }

    private static boolean isDocumented(Restlet current) {
        boolean documented = false;
        Router router = null;
        if (current instanceof Router) {
            router = (Router)current;
            for (Route route : router.getRoutes()) {
                if (!SwaggerApplication.isDocumented(route.getNext())) continue;
                documented = true;
                break;
            }
        } else if (current instanceof Filter) {
            documented = SwaggerApplication.isDocumented(((Filter)current).getNext());
        } else if (current instanceof SwaggerSpecificationRestlet) {
            documented = true;
        }
        return documented;
    }

    public void attachSwaggerDocumentationRestlets(Router router, String resourceListingPath, Restlet resourceListingRestlet, String apiDeclarationPath, Restlet apiDeclarationRestlet) {
        router.attach(resourceListingPath, resourceListingRestlet);
        router.attach(apiDeclarationPath, apiDeclarationRestlet);
        this.documented = true;
    }

    public void attachSwaggerSpecificationRestlet(Router router) {
        this.getSwaggerSpecificationRestlet(this.getContext()).attach(router);
        this.documented = true;
    }

    public void attachSwaggerSpecificationRestlet(Router router, String path) {
        this.getSwaggerSpecificationRestlet(this.getContext()).attach(router, path);
        this.documented = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Restlet getInboundRoot() {
        Restlet inboundRoot = super.getInboundRoot();
        if (!this.documented) {
            SwaggerApplication swaggerApplication = this;
            synchronized (swaggerApplication) {
                if (!this.documented) {
                    Router rootRouter = SwaggerApplication.getNextRouter(inboundRoot);
                    this.documented = SwaggerApplication.isDocumented((Restlet)rootRouter);
                    if (!this.documented) {
                        this.attachSwaggerSpecificationRestlet(rootRouter);
                        this.documented = true;
                    }
                }
            }
        }
        return inboundRoot;
    }

    public SwaggerSpecificationRestlet getSwaggerSpecificationRestlet(Context context) {
        SwaggerSpecificationRestlet result = new SwaggerSpecificationRestlet(context);
        result.setApiInboundRoot(this);
        return result;
    }
}

