/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.thymeleaf;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.representation.WriterRepresentation;
import org.restlet.util.Resolver;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.util.Validate;

public class TemplateRepresentation
extends WriterRepresentation {
    protected volatile IContext context;
    private volatile TemplateEngine engine;
    private final Locale locale;
    private volatile String templateName;

    public static TemplateEngine createTemplateEngine() {
        return TemplateRepresentation.createTemplateEngine(TemplateRepresentation.createTemplateResolver());
    }

    public static TemplateEngine createTemplateEngine(ITemplateResolver resolver) {
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver(resolver);
        return engine;
    }

    public static ITemplateResolver createTemplateResolver() {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setTemplateMode("XHTML");
        templateResolver.setPrefix("/WEB-INF/templates/");
        templateResolver.setSuffix(".html");
        templateResolver.setCacheTTLMs(Long.valueOf(3600000L));
        return templateResolver;
    }

    public TemplateRepresentation(String templateName, Locale locale, Map<String, Object> dataModel, MediaType mediaType) {
        this(templateName, TemplateRepresentation.createTemplateEngine(), locale, mediaType);
    }

    public TemplateRepresentation(String templateName, Locale locale, MediaType mediaType) {
        this(templateName, locale, new ConcurrentHashMap<String, Object>(), mediaType);
    }

    public TemplateRepresentation(String templateName, TemplateEngine engine, Locale locale, Map<String, Object> dataModel, MediaType mediaType) {
        super(mediaType);
        this.locale = locale;
        this.engine = engine;
        this.templateName = templateName;
        this.setDataModel(dataModel);
    }

    public TemplateRepresentation(String templateName, TemplateEngine engine, Locale locale, MediaType mediaType) {
        this(templateName, engine, locale, new ConcurrentHashMap<String, Object>(), mediaType);
    }

    public TemplateRepresentation(TemplateRepresentation templateRepresentation, Locale locale, MediaType mediaType) throws IOException {
        this(templateRepresentation, TemplateRepresentation.createTemplateEngine(), locale, mediaType);
    }

    public TemplateRepresentation(TemplateRepresentation templateRepresentation, TemplateEngine engine, Locale locale, MediaType mediaType) throws IOException {
        super(mediaType);
        this.locale = locale;
        this.engine = engine;
        this.templateName = templateRepresentation.getTemplateName();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    protected void setContext(IContext context) {
        this.context = context;
    }

    public void setDataModel(Map<String, Object> dataModel) {
        org.thymeleaf.context.Context ctx = new org.thymeleaf.context.Context(this.locale);
        ctx.setVariables(dataModel);
        this.setContext((IContext)ctx);
    }

    public void setDataModel(Request request, Response response) {
        Form form = new Form(request.getEntity());
        org.thymeleaf.context.Context ctx = new org.thymeleaf.context.Context(this.locale);
        ctx.setVariables(form.getValuesMap());
        this.setContext((IContext)ctx);
    }

    public void setDataModel(Resolver<Object> resolver) {
        this.setContext(new ResolverContext(this.locale, resolver));
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void write(Writer writer) throws IOException {
        try {
            this.engine.process(this.templateName, this.context, writer);
        }
        catch (Exception e) {
            Context context = Context.getCurrent();
            if (context != null) {
                context.getLogger().log(Level.WARNING, "Unable to process the template", e);
            }
            e.printStackTrace();
            throw new IOException("Template processing error. " + e.getMessage());
        }
    }

    private static class ResolverContext
    implements IContext {
        private Locale locale;
        private Resolver<Object> resolver;

        public ResolverContext(Locale locale, Resolver<Object> resolver) {
            this.locale = locale;
            this.resolver = resolver;
        }

        public final void addContextExecutionInfo(String templateName) {
            Validate.notEmpty((String)templateName, (String)"Template name cannot be null or empty");
        }

        public Locale getLocale() {
            return this.locale;
        }

        public VariablesMap<String, Object> getVariables() {
            return new VariablesMap<String, Object>(){

                public boolean containsKey(Object key) {
                    return ResolverContext.this.resolver.resolve(key.toString()) != null;
                }

                public Object get(Object key) {
                    return ResolverContext.this.resolver.resolve(key.toString());
                }
            };
        }
    }
}

