/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.thymeleaf;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Encoding;
import org.restlet.data.Status;
import org.restlet.ext.thymeleaf.TemplateRepresentation;
import org.restlet.representation.Representation;
import org.restlet.routing.Filter;
import org.restlet.util.Resolver;

public abstract class TemplateFilter
extends Filter {
    private static final Encoding THYMELEAF = new Encoding("thymeleaf", "Thymeleaf templated representation");
    private volatile Map<String, Object> mapDataModel;
    private volatile Resolver<Object> resolverDataModel;

    public TemplateFilter() {
    }

    public TemplateFilter(Context context) {
        super(context);
    }

    public TemplateFilter(Context context, Restlet next) {
        super(context, next);
        this.mapDataModel = null;
        this.resolverDataModel = null;
    }

    public TemplateFilter(Context context, Restlet next, Map<String, Object> dataModel) {
        super(context, next);
        this.mapDataModel = dataModel;
        this.resolverDataModel = null;
    }

    public TemplateFilter(Context context, Restlet next, Resolver<Object> dataModel) {
        super(context, next);
        this.mapDataModel = null;
        this.resolverDataModel = dataModel;
    }

    protected void afterHandle(Request request, Response response) {
        if (response.isEntityAvailable() && response.getEntity().getEncodings().contains(THYMELEAF)) {
            try {
                TemplateRepresentation representation = new TemplateRepresentation((TemplateRepresentation)response.getEntity(), this.getLocale(), response.getEntity().getMediaType());
                if (this.mapDataModel == null && this.resolverDataModel == null) {
                    representation.setDataModel(request, response);
                } else if (this.mapDataModel == null) {
                    representation.setDataModel(this.resolverDataModel);
                } else {
                    representation.setDataModel(this.mapDataModel);
                }
                response.setEntity((Representation)representation);
            }
            catch (IOException e) {
                response.setStatus(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
        }
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }
}

