/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.List;
import java.util.Map;
import org.restlet.data.Reference;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IncludeInfo
extends DocumentedInfo {
    private Reference targetRef;

    public IncludeInfo() {
    }

    public IncludeInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public IncludeInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public IncludeInfo(String documentation) {
        super(documentation);
    }

    public Reference getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(Reference href) {
        this.targetRef = href;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getTargetRef() != null && this.getTargetRef().toString() != null) {
            attributes.addAttribute("", "href", null, "xs:anyURI", this.getTargetRef().toString());
        }
        if (this.getDocumentations().isEmpty()) {
            writer.emptyElement("http://wadl.dev.java.net/2009/02", "include", null, (Attributes)attributes);
        } else {
            writer.startElement("http://wadl.dev.java.net/2009/02", "include", null, (Attributes)attributes);
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            writer.endElement("http://wadl.dev.java.net/2009/02", "include");
        }
    }
}

