/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xdb.internal;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.ServletConfig;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Status;
import org.restlet.engine.local.Entity;
import org.restlet.ext.servlet.internal.ServletWarClientHelper;
import org.restlet.ext.xdb.XdbServerServlet;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.service.MetadataService;

public class XdbServletWarClientHelper
extends ServletWarClientHelper {
    private static final String DEPLOY_DIR = "/wars/";
    private static final String HOME_DIR = "/$HOME";
    private static final String USER_DIR = "/home/";
    private volatile ServletConfig config;
    private volatile Connection conn = null;
    private volatile String connectedUser;

    public XdbServletWarClientHelper(Client client, ServletConfig config, Connection conn) {
        super(client, config.getServletContext());
        this.config = config;
        this.conn = conn;
    }

    public ServletConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLocal(Request request, Response response, String decodedPath) {
        block18: {
            block15: {
                Representation output;
                String entry;
                String xdbResPath;
                ResultSet rset;
                PreparedStatement stmt;
                block16: {
                    stmt = null;
                    rset = null;
                    if (!request.getMethod().equals((Object)Method.GET) && !request.getMethod().equals((Object)Method.HEAD)) break block15;
                    String basePath = request.getResourceRef().getPath();
                    xdbResPath = request.getProtocol().equals((Object)Protocol.FILE) ? (basePath.startsWith(HOME_DIR) ? USER_DIR + this.connectedUser + basePath.substring(HOME_DIR.length()) : basePath) : USER_DIR + this.connectedUser + DEPLOY_DIR + this.config.getServletName() + basePath;
                    int lastSlashIndex = basePath.lastIndexOf(47);
                    entry = lastSlashIndex == -1 ? basePath : basePath.substring(lastSlashIndex + 1);
                    output = null;
                    if (!basePath.endsWith("/")) break block16;
                    try {
                        stmt = this.conn.prepareStatement("SELECT path(1),extractValue(res,'/Resource/@Container') FROM resource_view WHERE under_path(res,1,?,1 ) = 1");
                        this.getLogger().info("looking resources at: " + xdbResPath);
                        stmt.setString(1, xdbResPath);
                        rset = stmt.executeQuery();
                        ReferenceList rl = new ReferenceList();
                        String baseUri = request.getResourceRef().getScheme() + "://" + basePath;
                        rl.setIdentifier(request.getResourceRef());
                        while (rset.next()) {
                            entry = rset.getString(1) + ("true".equalsIgnoreCase(rset.getString(2)) ? "/" : "");
                            this.getLogger().info("Reference: " + baseUri + entry);
                            rl.add((Object)new Reference(baseUri + entry));
                        }
                        output = rl.getTextRepresentation();
                    }
                    catch (SQLException sqe) {
                        try {
                            this.getLogger().throwing("XdbServletWarClientHelper", "handleWar", sqe);
                            throw new RuntimeException("Exception querying resource_view - xdbResPath: " + xdbResPath, sqe);
                        }
                        catch (Throwable throwable) {
                            XdbServerServlet.closeDbResources(stmt, rset);
                            throw throwable;
                        }
                    }
                    XdbServerServlet.closeDbResources(stmt, rset);
                    response.setEntity(output);
                    response.setStatus(Status.SUCCESS_OK);
                    break block18;
                }
                try {
                    stmt = this.conn.prepareStatement("select xdbURIType(any_path).getBlob(),extractValue(res,'/Resource/ModificationDate'),extractValue(res,'/Resource/ContentType') from resource_view where equals_path(res,?)=1");
                    stmt.setString(1, xdbResPath);
                    this.getLogger().info("looking resources at: " + xdbResPath);
                    rset = stmt.executeQuery();
                    if (rset.next()) {
                        Blob blob = (Blob)rset.getObject(1);
                        Timestamp modTime = rset.getTimestamp(2);
                        String mediaType = rset.getString(3);
                        if (blob != null) {
                            InputStream is = null;
                            is = blob.getBinaryStream();
                            MetadataService metadataService = this.getMetadataService();
                            output = new InputRepresentation(is, metadataService.getDefaultMediaType());
                            output.setLocationRef(request.getResourceRef());
                            Entity.updateMetadata((String)entry, (Variant)output, (boolean)true, (MetadataService)this.getMetadataService());
                            if (mediaType != null) {
                                this.getLogger().info("mediaType: " + mediaType);
                                this.getLogger().info("modTime: " + modTime);
                                output.setMediaType(new MediaType(mediaType));
                                output.setModificationDate((java.util.Date)new Date(modTime.getTime()));
                            }
                            response.setEntity(output);
                            response.setStatus(Status.SUCCESS_OK);
                        } else {
                            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                        }
                    }
                    XdbServerServlet.closeDbResources(stmt, rset);
                }
                catch (SQLException sqe) {
                    if (sqe.getErrorCode() == 31001) {
                        response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                    }
                    this.getLogger().throwing("XdbServletWarClientHelper", "handleWar: ", sqe);
                    throw new RuntimeException("Exception querying xdburitype(?).getBlob() - xdbResPath: " + xdbResPath, sqe);
                }
                finally {
                    XdbServerServlet.closeDbResources(stmt, rset);
                }
            }
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
        }
    }

    public synchronized void start() throws Exception {
        super.start();
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            stmt = this.conn.prepareStatement("select USER from dual");
            rset = stmt.executeQuery();
            this.connectedUser = rset.next() ? rset.getString(1) : "PUBLIC";
            this.getLogger().info("efective user is: " + this.connectedUser);
        }
        catch (SQLException sqe) {
            try {
                this.getLogger().throwing("XdbServletWarClientHelper", "start", sqe);
                throw new RuntimeException("Exception querying USER from dual ", sqe);
            }
            catch (Throwable throwable) {
                XdbServerServlet.closeDbResources(stmt, rset);
                throw throwable;
            }
        }
        XdbServerServlet.closeDbResources(stmt, rset);
    }
}

