/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.ext.xml.NodeList;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlRepresentation
extends WriterRepresentation
implements NamespaceContext {
    public static boolean XML_EXPANDING_ENTITY_REFS = Boolean.getBoolean("org.restlet.ext.xml.expandingEntityRefs");
    public static boolean XML_VALIDATING_DTD = Boolean.getBoolean("org.restlet.ext.xml.validatingDtd");
    private volatile EntityResolver entityResolver = null;
    private volatile ErrorHandler errorHandler = null;
    private volatile boolean namespaceAware = false;
    private volatile Map<String, String> namespaces = null;
    private volatile Schema schema = null;
    private volatile boolean validatingDtd;
    private volatile boolean coalescing = false;
    private volatile boolean expandingEntityRefs = XML_EXPANDING_ENTITY_REFS;
    private volatile boolean ignoringComments = false;
    private volatile boolean ignoringExtraWhitespaces = false;
    private volatile boolean xIncludeAware = false;

    public static SAXSource getSaxSource(Representation xmlRepresentation) throws IOException {
        SAXSource result = null;
        if (xmlRepresentation != null) {
            result = new SAXSource(new InputSource(xmlRepresentation.getStream()));
            if (xmlRepresentation.getLocationRef() != null) {
                result.setSystemId(xmlRepresentation.getLocationRef().getTargetRef().toString());
            }
        }
        return result;
    }

    private static Schema getSchema(Representation schemaRepresentation) throws Exception {
        Schema result = null;
        if (schemaRepresentation != null) {
            StreamSource streamSource = new StreamSource(schemaRepresentation.getStream());
            result = SchemaFactory.newInstance(XmlRepresentation.getSchemaLanguageUri(schemaRepresentation)).newSchema(streamSource);
        }
        return result;
    }

    private static String getSchemaLanguageUri(Representation schemaRepresentation) {
        String result = null;
        if (schemaRepresentation != null) {
            if (MediaType.APPLICATION_W3C_SCHEMA.equals((Object)schemaRepresentation.getMediaType())) {
                result = "http://www.w3.org/2001/XMLSchema";
            } else if (MediaType.APPLICATION_RELAXNG_COMPACT.equals((Object)schemaRepresentation.getMediaType())) {
                result = "http://relaxng.org/ns/structure/1.0";
            } else if (MediaType.APPLICATION_RELAXNG_XML.equals((Object)schemaRepresentation.getMediaType())) {
                result = "http://relaxng.org/ns/structure/1.0";
            }
        }
        return result;
    }

    public XmlRepresentation(MediaType mediaType) {
        this(mediaType, -1L);
    }

    public XmlRepresentation(MediaType mediaType, long expectedSize) {
        super(mediaType, expectedSize);
        this.validatingDtd = XML_VALIDATING_DTD;
    }

    public Boolean getBoolean(String expression) {
        return (Boolean)this.internalEval(expression, XPathConstants.BOOLEAN);
    }

    protected Document getDocument() throws Exception {
        return this.getDocumentBuilder().parse(this.getInputSource());
    }

    protected DocumentBuilder getDocumentBuilder() throws IOException {
        DocumentBuilder result = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(this.isNamespaceAware());
            dbf.setValidating(this.isValidatingDtd());
            dbf.setCoalescing(this.isCoalescing());
            dbf.setExpandEntityReferences(this.isExpandingEntityRefs());
            dbf.setIgnoringComments(this.isIgnoringComments());
            dbf.setIgnoringElementContentWhitespace(this.isIgnoringExtraWhitespaces());
            try {
                dbf.setXIncludeAware(this.isXIncludeAware());
            }
            catch (UnsupportedOperationException uoe) {
                Context.getCurrentLogger().log(Level.FINE, "The JAXP parser doesn't support XInclude.", uoe);
            }
            Schema xsd = this.getSchema();
            if (xsd != null) {
                dbf.setSchema(xsd);
            }
            result = dbf.newDocumentBuilder();
            result.setEntityResolver(this.getEntityResolver());
            result.setErrorHandler(this.getErrorHandler());
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Couldn't create the empty document: " + pce.getMessage());
        }
        return result;
    }

    public DOMSource getDomSource() throws IOException {
        DOMSource result = null;
        Document document = null;
        try {
            document = this.getDocumentBuilder().parse(this.getInputSource());
        }
        catch (SAXException se) {
            throw new IOException("Couldn't read the XML representation. " + se.getMessage());
        }
        if (document != null) {
            result = new DOMSource(document);
            if (this.getLocationRef() != null) {
                result.setSystemId(this.getLocationRef().getTargetRef().toString());
            }
        }
        return result;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public abstract InputSource getInputSource() throws IOException;

    public Map<String, String> getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        return this.namespaces;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaces == null ? null : this.namespaces.get(prefix);
    }

    public Node getNode(String expression) {
        return (Node)this.internalEval(expression, XPathConstants.NODE);
    }

    public NodeList getNodes(String expression) {
        org.w3c.dom.NodeList nodes = (org.w3c.dom.NodeList)this.internalEval(expression, XPathConstants.NODESET);
        return nodes == null ? null : new NodeList(nodes);
    }

    public Double getNumber(String expression) {
        return (Double)this.internalEval(expression, XPathConstants.NUMBER);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        String result = null;
        boolean found = false;
        Iterator<String> iterator = this.getNamespaces().keySet().iterator();
        while (iterator.hasNext() && !found) {
            String key = iterator.next();
            if (!this.getNamespaces().get(key).equals(namespaceURI)) continue;
            found = true;
            result = key;
        }
        return result;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.getNamespaces().keySet()) {
            if (!this.getNamespaces().get(key).equals(namespaceURI)) continue;
            result.add(key);
        }
        return Collections.unmodifiableList(result).iterator();
    }

    public SAXSource getSaxSource() throws IOException {
        return XmlRepresentation.getSaxSource((Representation)this);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public StreamSource getStreamSource() throws IOException {
        StreamSource result = new StreamSource(this.getStream());
        if (this.getLocationRef() != null) {
            result.setSystemId(this.getLocationRef().getTargetRef().toString());
        }
        return result;
    }

    public String getText(String expression) {
        return (String)this.internalEval(expression, XPathConstants.STRING);
    }

    private Object internalEval(String expression, QName returnType) {
        try {
            Object result = null;
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(this);
            Document xmlDocument = this.getDocument();
            if (xmlDocument == null) {
                throw new Exception("Unable to obtain a DOM document for the XML representation. XPath evaluation cancelled.");
            }
            result = xpath.evaluate(expression, xmlDocument, returnType);
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public boolean isExpandingEntityRefs() {
        return this.expandingEntityRefs;
    }

    public boolean isIgnoringComments() {
        return this.ignoringComments;
    }

    public boolean isIgnoringExtraWhitespaces() {
        return this.ignoringExtraWhitespaces;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidatingDtd() {
        return this.validatingDtd;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void release() {
        if (this.namespaces != null) {
            this.namespaces.clear();
            this.namespaces = null;
        }
        super.release();
    }

    public void setCoalescing(boolean coalescing) {
        this.coalescing = coalescing;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setExpandingEntityRefs(boolean expandEntityRefs) {
        this.expandingEntityRefs = expandEntityRefs;
    }

    public void setIgnoringComments(boolean ignoringComments) {
        this.ignoringComments = ignoringComments;
    }

    public void setIgnoringExtraWhitespaces(boolean ignoringExtraWhitespaces) {
        if (this.ignoringExtraWhitespaces != ignoringExtraWhitespaces) {
            if (ignoringExtraWhitespaces) {
                this.setValidatingDtd(true);
            }
            this.ignoringExtraWhitespaces = ignoringExtraWhitespaces;
        }
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setSchema(Representation schemaRepresentation) {
        try {
            this.schema = XmlRepresentation.getSchema(schemaRepresentation);
        }
        catch (Exception e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to compile the schema representation", e);
        }
    }

    public void setValidatingDtd(boolean validating) {
        this.validatingDtd = validating;
    }

    public void setXIncludeAware(boolean includeAware) {
        this.xIncludeAware = includeAware;
    }

    public void validate(Schema schema) throws Exception {
        this.validate(schema, null);
    }

    public void validate(Schema schema, Result result) throws Exception {
        schema.newValidator().validate(this.getSaxSource(), result);
    }

    public void validate(Representation schemaRepresentation) throws Exception {
        this.validate(schemaRepresentation, null);
    }

    public void validate(Representation schemaRepresentation, Result result) throws Exception {
        this.validate(XmlRepresentation.getSchema(schemaRepresentation), result);
    }
}

