/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.xstream.XstreamRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class XstreamConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_ALL_XML = new VariantInfo(MediaType.APPLICATION_ALL_XML);
    private static final VariantInfo VARIANT_APPLICATION_XML = new VariantInfo(MediaType.APPLICATION_XML);
    private static final VariantInfo VARIANT_JSON = new VariantInfo(MediaType.APPLICATION_JSON);
    private static final VariantInfo VARIANT_TEXT_XML = new VariantInfo(MediaType.TEXT_XML);
    private Class<? extends HierarchicalStreamDriver> jsonDriverClass = JettisonMappedXmlDriver.class;
    private Class<? extends HierarchicalStreamDriver> xmlDriverClass = DomDriver.class;

    protected <T> XstreamRepresentation<T> create(MediaType mediaType, T source) {
        return new XstreamRepresentation<T>(mediaType, source);
    }

    protected <T> XstreamRepresentation<T> create(Representation source, Class<T> target) throws IOException {
        XstreamRepresentation<T> representation = new XstreamRepresentation<T>(source, target);
        representation.setXstream(this.createXstream(source.getMediaType(), target));
        return representation;
    }

    public <T> XStream createXstream(MediaType mediaType, Class<T> target) throws IOException {
        XStream result = null;
        try {
            if (MediaType.APPLICATION_JSON.isCompatible((Metadata)mediaType)) {
                result = new XStream(this.getJsonDriverClass().newInstance());
                result.setMode(1001);
            } else {
                result = new XStream(this.getXmlDriverClass().newInstance());
            }
            result.addPermission(NoTypePermission.NONE);
            result.addPermission(NullPermission.NULL);
            result.addPermission(PrimitiveTypePermission.PRIMITIVES);
            result.allowTypeHierarchy(Collection.class);
            result.allowTypesByWildcard(new String[]{target.getPackage().getName() + ".*"});
            result.autodetectAnnotations(true);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to create the XStream driver: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return result;
    }

    public Class<? extends HierarchicalStreamDriver> getJsonDriverClass() {
        return this.jsonDriverClass;
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_JSON.isCompatible(source) || VARIANT_APPLICATION_ALL_XML.isCompatible(source) || VARIANT_APPLICATION_XML.isCompatible(source) || VARIANT_TEXT_XML.isCompatible(source)) {
            result = this.addObjectClass(result, Object.class);
            result = this.addObjectClass(result, XstreamRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (source != null) {
            result = this.addVariant(result, VARIANT_JSON);
            result = this.addVariant(result, VARIANT_APPLICATION_ALL_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_XML);
            result = this.addVariant(result, VARIANT_TEXT_XML);
        }
        return result;
    }

    public Class<? extends HierarchicalStreamDriver> getXmlDriverClass() {
        return this.xmlDriverClass;
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        result = source instanceof XstreamRepresentation ? 1.0f : (target == null ? 0.5f : (VARIANT_JSON.isCompatible(target) ? 0.8f : (VARIANT_APPLICATION_ALL_XML.isCompatible(target) || VARIANT_APPLICATION_XML.isCompatible(target) || VARIANT_TEXT_XML.isCompatible(target) ? 0.8f : 0.5f)));
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (target != null) {
            if (source instanceof XstreamRepresentation) {
                result = 1.0f;
            } else if (XstreamRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (VARIANT_JSON.isCompatible((Variant)source)) {
                result = 0.8f;
            } else if (VARIANT_APPLICATION_ALL_XML.isCompatible((Variant)source) || VARIANT_APPLICATION_XML.isCompatible((Variant)source) || VARIANT_TEXT_XML.isCompatible((Variant)source)) {
                result = 0.8f;
            }
        } else {
            result = 0.5f;
        }
        return result;
    }

    public void setJsonDriverClass(Class<? extends HierarchicalStreamDriver> jsonDriverClass) {
        this.jsonDriverClass = jsonDriverClass;
    }

    public void setXmlDriverClass(Class<? extends HierarchicalStreamDriver> xmlDriverClass) {
        this.xmlDriverClass = xmlDriverClass;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        T result = null;
        XstreamRepresentation<T> xstreamSource = null;
        if (source instanceof XstreamRepresentation) {
            xstreamSource = (XstreamRepresentation<T>)source;
            if (target != null) {
                xstreamSource.getXstream().processAnnotations(target);
            }
        } else if (VARIANT_JSON.isCompatible((Variant)source)) {
            xstreamSource = this.create(source, target);
        } else if (VARIANT_APPLICATION_ALL_XML.isCompatible((Variant)source) || VARIANT_APPLICATION_XML.isCompatible((Variant)source) || VARIANT_TEXT_XML.isCompatible((Variant)source)) {
            xstreamSource = this.create(source, target);
        }
        if (xstreamSource != null) {
            try {
                result = target != null && XstreamRepresentation.class.isAssignableFrom(target) ? (T)target.cast(xstreamSource) : (T)xstreamSource.getObject();
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("SECURITY WARNING: The usage of XstreamRepresentation when deserializing representations from unstrusted sources can lead to malicious attacks. As pointed here (http://xstream.codehaus.org/security.html), it is possible to force the JVM to execute unwanted Java code described inside the representation.Thus, the support of such format has been restricted by default to basic data types such as primitive types, subclasses of the java.util.Collection class (cf http://xstream.codehaus.org/security.html#framework). You can enhance this behavior by overriding the org.restlet.ext.xstream.XStreamConverter#createXstream(MediaType, Class<T>) method and provide this new converter helper to the Restlet Engine (see org.restlet.engine.Engine#getRegisteredConverters method).", iae);
            }
        }
        return result;
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        XstreamRepresentation<Object> result = null;
        if (source instanceof XstreamRepresentation) {
            result = (XstreamRepresentation<Object>)((Object)source);
        } else {
            if (target.getMediaType() == null) {
                target.setMediaType(MediaType.TEXT_XML);
            }
            if (VARIANT_JSON.isCompatible(target)) {
                XstreamRepresentation<Object> xstreamRepresentation;
                result = xstreamRepresentation = this.create(target.getMediaType(), source);
            } else if (VARIANT_APPLICATION_ALL_XML.isCompatible(target) || VARIANT_APPLICATION_XML.isCompatible(target) || VARIANT_TEXT_XML.isCompatible(target)) {
                result = this.create(target.getMediaType(), source);
            }
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        this.updatePreferences(preferences, MediaType.APPLICATION_ALL_XML, 1.0f);
        this.updatePreferences(preferences, MediaType.APPLICATION_JSON, 1.0f);
        this.updatePreferences(preferences, MediaType.APPLICATION_XML, 1.0f);
        this.updatePreferences(preferences, MediaType.TEXT_XML, 1.0f);
    }
}

