/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;

@Deprecated
public class XstreamRepresentation<T>
extends WriterRepresentation {
    private Class<? extends HierarchicalStreamDriver> jsonDriverClass;
    private T object;
    private Representation representation;
    private Class<T> targetClass;
    private Class<? extends HierarchicalStreamDriver> xmlDriverClass;
    private XStream xstream;

    public XstreamRepresentation(MediaType mediaType, T object) {
        super(mediaType);
        this.object = object;
        this.representation = null;
        this.jsonDriverClass = JettisonMappedXmlDriver.class;
        this.xmlDriverClass = DomDriver.class;
        this.xstream = null;
    }

    public XstreamRepresentation(Representation representation, Class<T> targetClass) {
        super(representation.getMediaType());
        this.object = null;
        this.targetClass = targetClass;
        this.representation = representation;
        this.jsonDriverClass = JettisonMappedXmlDriver.class;
        this.xmlDriverClass = DomDriver.class;
        this.xstream = null;
    }

    public XstreamRepresentation(T object) {
        this(MediaType.APPLICATION_XML, object);
    }

    protected XStream createXstream(MediaType mediaType) throws IOException {
        XStream result = null;
        try {
            if (MediaType.APPLICATION_JSON.isCompatible((Metadata)mediaType)) {
                result = new XStream(this.getJsonDriverClass().newInstance());
                result.setMode(1001);
            } else {
                result = new XStream(this.getXmlDriverClass().newInstance());
            }
            result.autodetectAnnotations(true);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to create the XStream driver: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return result;
    }

    public Class<? extends HierarchicalStreamDriver> getJsonDriverClass() {
        return this.jsonDriverClass;
    }

    public T getObject() throws IOException {
        Object result = null;
        if (this.object != null) {
            this.getXstream().processAnnotations(this.object.getClass());
            result = this.object;
        } else if (this.representation != null) {
            if (this.targetClass != null) {
                this.getXstream().processAnnotations(this.targetClass);
            }
            try {
                result = this.getXstream().fromXML(this.representation.getStream());
            }
            catch (ForbiddenClassException fce) {
                throw new IllegalArgumentException("SECURITY WARNING: The usage of XstreamRepresentation when deserializing representations from unstrusted sources can lead to malicious attacks. As pointed here (http://xstream.codehaus.org/security.html), it is possible to force the JVM to execute unwanted Java code described inside the representation.Thus, the support of such format has been restricted by default to basic data types such as primitive types, subclasses of the java.util.Collection class (cf http://xstream.codehaus.org/security.html#framework). You can override this behavior by setting your own XStream facade object (see XStreamRepresentation#setXStream method).", fce);
            }
        }
        return (T)result;
    }

    public Class<? extends HierarchicalStreamDriver> getXmlDriverClass() {
        return this.xmlDriverClass;
    }

    public XStream getXstream() throws IOException {
        if (this.xstream == null) {
            this.xstream = this.createXstream(this.getMediaType());
            this.xstream.addPermission(NoTypePermission.NONE);
            this.xstream.addPermission(NullPermission.NULL);
            this.xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
            this.xstream.allowTypeHierarchy(Collection.class);
        }
        return this.xstream;
    }

    public void setJsonDriverClass(Class<? extends HierarchicalStreamDriver> jsonDriverClass) {
        this.jsonDriverClass = jsonDriverClass;
    }

    public void setXmlDriverClass(Class<? extends HierarchicalStreamDriver> xmlDriverClass) {
        this.xmlDriverClass = xmlDriverClass;
    }

    public void setXstream(XStream xstream) {
        this.xstream = xstream;
    }

    public void write(Writer writer) throws IOException {
        if (this.representation != null) {
            this.representation.write(writer);
        } else if (this.object != null) {
            CharacterSet charSet;
            CharacterSet characterSet = charSet = this.getCharacterSet() == null ? CharacterSet.ISO_8859_1 : this.getCharacterSet();
            if (!MediaType.APPLICATION_JSON.isCompatible((Metadata)this.getMediaType())) {
                writer.append("<?xml version=\"1.0\" encoding=\"" + charSet.getName() + "\" ?>\n");
            }
            this.getXstream().toXML(this.object, writer);
        }
    }
}

