/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Reference;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.service.ConnegService;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;
import org.restlet.service.StatusService;
import org.restlet.util.Series;

public abstract class Resource {
    private volatile Application application;
    private volatile Context context;
    private volatile Request request;
    private volatile Response response;

    protected void doCatch(Throwable throwable) {
        this.getLogger().log(Level.INFO, "Exception or error caught in resource", throwable);
    }

    protected void doError(Status errorStatus) {
    }

    protected final void doError(Status errorStatus, String errorMessage) {
        this.doError(new Status(errorStatus, errorMessage));
    }

    protected void doInit() throws ResourceException {
    }

    protected void doRelease() throws ResourceException {
    }

    public Set<Method> getAllowedMethods() {
        return this.getResponse() == null ? null : this.getResponse().getAllowedMethods();
    }

    public Application getApplication() {
        Application result = this.application;
        if (result == null) {
            result = Application.getCurrent();
            if (result == null) {
                result = new Application(this.getContext());
            }
            this.application = result;
        }
        return result;
    }

    public abstract String getAttribute(String var1);

    public List<ChallengeRequest> getChallengeRequests() {
        return this.getResponse() == null ? null : this.getResponse().getChallengeRequests();
    }

    public ChallengeResponse getChallengeResponse() {
        return this.getRequest() == null ? null : this.getRequest().getChallengeResponse();
    }

    public ClientInfo getClientInfo() {
        return this.getRequest() == null ? null : this.getRequest().getClientInfo();
    }

    public Conditions getConditions() {
        return this.getRequest() == null ? null : this.getRequest().getConditions();
    }

    public ConnegService getConnegService() {
        ConnegService result = null;
        result = this.getApplication().getConnegService();
        if (result == null) {
            result = new ConnegService();
        }
        return result;
    }

    public Context getContext() {
        return this.context;
    }

    public ConverterService getConverterService() {
        ConverterService result = null;
        result = this.getApplication().getConverterService();
        if (result == null) {
            result = new ConverterService();
        }
        return result;
    }

    public Series<Cookie> getCookies() {
        return this.getRequest() == null ? null : this.getRequest().getCookies();
    }

    public Series<CookieSetting> getCookieSettings() {
        return this.getResponse() == null ? null : this.getResponse().getCookieSettings();
    }

    public Set<Dimension> getDimensions() {
        return this.getResponse() == null ? null : this.getResponse().getDimensions();
    }

    public Reference getHostRef() {
        return this.getRequest() == null ? null : this.getRequest().getHostRef();
    }

    public Reference getLocationRef() {
        return this.getResponse() == null ? null : this.getResponse().getLocationRef();
    }

    public Logger getLogger() {
        return this.getContext() != null ? this.getContext().getLogger() : Context.getCurrentLogger();
    }

    public Form getMatrix() {
        return this.getReference() == null ? null : this.getReference().getMatrixAsForm();
    }

    public String getMatrixValue(String name) {
        String result = null;
        Form matrix = this.getMatrix();
        if (matrix != null) {
            result = matrix.getFirstValue(name);
        }
        return result;
    }

    public int getMaxForwards() {
        return this.getRequest() == null ? null : Integer.valueOf(this.getRequest().getMaxForwards());
    }

    public MetadataService getMetadataService() {
        MetadataService result = null;
        result = this.getApplication().getMetadataService();
        if (result == null) {
            result = new MetadataService();
        }
        return result;
    }

    public Method getMethod() {
        return this.getRequest() == null ? null : this.getRequest().getMethod();
    }

    public Reference getOriginalRef() {
        return this.getRequest() == null ? null : this.getRequest().getOriginalRef();
    }

    public Protocol getProtocol() {
        return this.getRequest() == null ? null : this.getRequest().getProtocol();
    }

    public List<ChallengeRequest> getProxyChallengeRequests() {
        return this.getResponse() == null ? null : this.getResponse().getProxyChallengeRequests();
    }

    public ChallengeResponse getProxyChallengeResponse() {
        return this.getRequest() == null ? null : this.getRequest().getProxyChallengeResponse();
    }

    public Form getQuery() {
        return this.getReference() == null ? null : this.getReference().getQueryAsForm();
    }

    public String getQueryValue(String name) {
        String result = null;
        Form query = this.getQuery();
        if (query != null) {
            result = query.getFirstValue(name);
        }
        return result;
    }

    public List<Range> getRanges() {
        return this.getRequest() == null ? null : this.getRequest().getRanges();
    }

    public Reference getReference() {
        return this.getRequest() == null ? null : this.getRequest().getResourceRef();
    }

    public Reference getReferrerRef() {
        return this.getRequest() == null ? null : this.getRequest().getReferrerRef();
    }

    public Request getRequest() {
        return this.request;
    }

    public Map<String, Object> getRequestAttributes() {
        return this.getRequest() == null ? null : this.getRequest().getAttributes();
    }

    public List<CacheDirective> getRequestCacheDirectives() {
        return this.getRequest() == null ? null : this.getRequest().getCacheDirectives();
    }

    public Representation getRequestEntity() {
        return this.getRequest() == null ? null : this.getRequest().getEntity();
    }

    public Response getResponse() {
        return this.response;
    }

    public Map<String, Object> getResponseAttributes() {
        return this.getResponse() == null ? null : this.getResponse().getAttributes();
    }

    public List<CacheDirective> getResponseCacheDirectives() {
        return this.getResponse() == null ? null : this.getResponse().getCacheDirectives();
    }

    public Representation getResponseEntity() {
        return this.getResponse() == null ? null : this.getResponse().getEntity();
    }

    public Reference getRootRef() {
        return this.getRequest() == null ? null : this.getRequest().getRootRef();
    }

    public ServerInfo getServerInfo() {
        return this.getResponse() == null ? null : this.getResponse().getServerInfo();
    }

    public Status getStatus() {
        return this.getResponse() == null ? null : this.getResponse().getStatus();
    }

    public StatusService getStatusService() {
        StatusService result = null;
        result = this.getApplication().getStatusService();
        if (result == null) {
            result = new StatusService();
        }
        return result;
    }

    public abstract Representation handle();

    public void init(Context context, Request request, Response response) {
        this.context = context;
        this.request = request;
        this.response = response;
        try {
            this.doInit();
        }
        catch (Throwable t) {
            this.doCatch(t);
        }
    }

    public boolean isConfidential() {
        return this.getRequest() == null ? null : Boolean.valueOf(this.getRequest().isConfidential());
    }

    public boolean isLoggable() {
        return this.getRequest() == null ? null : Boolean.valueOf(this.getRequest().isLoggable());
    }

    public final void release() {
        try {
            this.doRelease();
        }
        catch (Throwable t) {
            this.doCatch(t);
        }
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public abstract void setAttribute(String var1, Object var2);

    public void setQueryValue(String name, String value) {
        Form query = this.getQuery();
        if (query == null) {
            query = new Form();
        }
        query.set(name, value);
        try {
            this.getReference().setQuery(query.encode());
        }
        catch (IOException e) {
            this.getLogger().fine("Unable to set the query value");
        }
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public <T> T toObject(Representation source, Class<T> target) throws ResourceException {
        T result = null;
        if (source != null) {
            try {
                ConverterService cs = this.getConverterService();
                result = cs.toObject(source, target, this);
            }
            catch (Exception e) {
                throw new ResourceException(e);
            }
        }
        return result;
    }

    public Representation toRepresentation(Object source, Variant target) throws IOException {
        Representation result = null;
        if (source != null) {
            ConverterService cs = this.getConverterService();
            result = cs.toRepresentation(source, target, this);
        }
        return result;
    }

    public String toString() {
        return (this.getRequest() == null ? "" : this.getRequest().toString()) + (this.getResponse() == null ? "" : " => " + this.getResponse().toString());
    }
}

