/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.util.StringUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.routing.Filter;
import org.restlet.service.ConverterService;
import org.restlet.service.StatusService;

public class StatusFilter
extends Filter {
    private volatile String contactEmail;
    private volatile Reference homeRef;
    private volatile boolean overwriting;
    private volatile StatusService statusService;

    public StatusFilter(Context context, boolean overwriting, String email, Reference homeRef) {
        super(context);
        this.overwriting = overwriting;
        this.contactEmail = email;
        this.homeRef = homeRef;
        this.statusService = null;
    }

    public StatusFilter(Context context, StatusService statusService) {
        this(context, statusService.isOverwriting(), statusService.getContactEmail(), statusService.getHomeRef());
        this.statusService = statusService;
    }

    @Override
    public void afterHandle(Request request, Response response) {
        if (response.getStatus() == null) {
            response.setStatus(Status.SUCCESS_OK);
        }
        if (response.getStatus().isError() && (response.getEntity() == null || this.isOverwriting())) {
            response.setEntity(this.toRepresentation(response.getStatus(), null, request, response));
        }
    }

    @Override
    protected int doHandle(Request request, Response response) {
        block7: {
            try {
                super.doHandle(request, response);
            }
            catch (Throwable throwable) {
                Level level = Level.INFO;
                Status status = this.getStatusService().toStatus(throwable, request, response);
                if (status.isServerError()) {
                    level = Level.WARNING;
                } else if (status.isConnectorError()) {
                    level = Level.INFO;
                } else if (status.isClientError()) {
                    level = Level.FINE;
                }
                this.getLogger().log(level, "Exception or error caught by status service", throwable);
                if (response == null) break block7;
                response.setStatus(status);
                if (response.getEntity() != null && !this.isOverwriting()) break block7;
                response.setEntity(this.getStatusService().toRepresentation(status, throwable, request, response, this.getApplication().getConverterService()));
            }
        }
        return 0;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public ConverterService getConverterService() {
        return this.getApplication() == null ? null : this.getApplication().getConverterService();
    }

    protected Representation getDefaultRepresentation(Status status, Request request, Response response) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("   <title>Status page</title>\n");
        sb.append("</head>\n");
        sb.append("<body style=\"font-family: sans-serif;\">\n");
        sb.append("<p style=\"font-size: 1.2em;font-weight: bold;margin: 1em 0px;\">");
        sb.append(StringUtils.htmlEscape(this.getStatusInfo(status)));
        sb.append("</p>\n");
        if (status.getDescription() != null) {
            sb.append("<p>");
            sb.append(StringUtils.htmlEscape(status.getDescription()));
            sb.append("</p>\n");
        }
        sb.append("<p>You can get technical details <a href=\"");
        sb.append(status.getUri());
        sb.append("\">here</a>.<br>\n");
        if (this.getContactEmail() != null) {
            sb.append("For further assistance, you can contact the <a href=\"mailto:");
            sb.append(this.getContactEmail());
            sb.append("\">administrator</a>.<br>\n");
        }
        if (this.getHomeRef() != null) {
            sb.append("Please continue your visit at our <a href=\"");
            sb.append(this.getHomeRef());
            sb.append("\">home page</a>.\n");
        }
        sb.append("</p>\n");
        sb.append("</body>\n");
        sb.append("</html>\n");
        return new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
    }

    public Reference getHomeRef() {
        return this.homeRef;
    }

    @Deprecated
    protected Representation getRepresentation(Status status, Request request, Response response) {
        return this.toRepresentation(status, null, request, response);
    }

    @Deprecated
    protected Status getStatus(Throwable throwable, Request request, Response response) {
        return this.toStatus(throwable, request, response);
    }

    protected String getStatusInfo(Status status) {
        return status.getReasonPhrase() != null ? status.getReasonPhrase() : "No information available for this result status";
    }

    public StatusService getStatusService() {
        return this.statusService;
    }

    public boolean isOverwriting() {
        return this.overwriting;
    }

    public void setContactEmail(String email) {
        this.contactEmail = email;
    }

    public void setHomeRef(Reference homeRef) {
        this.homeRef = homeRef;
    }

    public void setOverwriting(boolean overwriting) {
        this.overwriting = overwriting;
    }

    public void setStatusService(StatusService statusService) {
        this.statusService = statusService;
    }

    protected Representation toRepresentation(Status status, Throwable throwable, Request request, Response response) {
        Representation result = null;
        try {
            result = this.getStatusService().toRepresentation(status, throwable, request, response, this.getConverterService());
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to get the custom status representation", e);
        }
        if (result == null) {
            result = this.getDefaultRepresentation(status, request, response);
        }
        return result;
    }

    protected Status toStatus(Throwable throwable, Request request, Response response) {
        return this.getStatusService().toStatus(throwable, request, response);
    }
}

