/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ClientInfo;
import org.restlet.data.Form;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.engine.resource.MethodAnnotationInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ClientProxy;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Result;

public class ClientInvocationHandler<T>
implements InvocationHandler {
    private final List<AnnotationInfo> annotations;
    private final ClientResource clientResource;
    private AnnotationUtils annotationUtils;

    public ClientInvocationHandler(ClientResource clientResource, Class<? extends T> resourceInterface) {
        this(clientResource, resourceInterface, AnnotationUtils.getInstance());
    }

    public ClientInvocationHandler(ClientResource clientResource, Class<? extends T> resourceInterface, AnnotationUtils annotationUtils) {
        this.clientResource = clientResource;
        this.annotationUtils = annotationUtils;
        this.annotations = this.annotationUtils.getAnnotations(resourceInterface);
    }

    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    public ClientResource getClientResource() {
        return this.clientResource;
    }

    protected Request getRequest(Method javaMethod, Object[] args) throws Throwable {
        return this.getClientResource().createRequest();
    }

    @Override
    public Object invoke(Object proxy, Method javaMethod, Object[] args) throws Throwable {
        Object result = null;
        if (javaMethod.equals(Object.class.getMethod("toString", new Class[0]))) {
            result = "ClientProxy for resource: " + this.clientResource;
        } else if (javaMethod.equals(ClientProxy.class.getMethod("getClientResource", new Class[0]))) {
            result = this.clientResource;
        } else {
            MethodAnnotationInfo annotationInfo = this.annotationUtils.getMethodAnnotation(this.annotations, javaMethod);
            if (annotationInfo != null) {
                List<Variant> responseVariants;
                Representation requestEntity = null;
                boolean isSynchronous = true;
                if (args != null && args.length > 0) {
                    for (int i = 0; i < args.length; ++i) {
                        Object o = args[i];
                        if (o == null) {
                            requestEntity = null;
                            continue;
                        }
                        if (Result.class.isAssignableFrom(o.getClass())) {
                            isSynchronous = false;
                            final Result rCallback = (Result)o;
                            Type[] genericParameterTypes = javaMethod.getGenericParameterTypes();
                            Type genericParameterType = genericParameterTypes[i];
                            ParameterizedType parameterizedType = genericParameterType instanceof ParameterizedType ? (ParameterizedType)genericParameterType : null;
                            final Class actualType = parameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)parameterizedType.getActualTypeArguments()[0] : null;
                            Uniform callback = new Uniform(){

                                @Override
                                public void handle(Request request, Response response) {
                                    if (response.getStatus().isError()) {
                                        rCallback.onFailure(new ResourceException(response.getStatus()));
                                    } else if (actualType != null) {
                                        Object result = null;
                                        boolean serializationError = false;
                                        try {
                                            result = ClientInvocationHandler.this.getClientResource().toObject(response.getEntity(), actualType);
                                        }
                                        catch (Exception e) {
                                            serializationError = true;
                                            rCallback.onFailure(new ResourceException(e));
                                        }
                                        if (!serializationError) {
                                            rCallback.onSuccess(result);
                                        }
                                    } else {
                                        rCallback.onSuccess(null);
                                    }
                                }
                            };
                            this.getClientResource().setOnResponse(callback);
                            continue;
                        }
                        requestEntity = this.getClientResource().toRepresentation(args[i]);
                    }
                }
                Request request = this.getRequest(javaMethod, args);
                request.setMethod(annotationInfo.getRestletMethod());
                String query = annotationInfo.getQuery();
                if (query != null) {
                    Form queryParams = new Form(annotationInfo.getQuery());
                    request.getResourceRef().addQueryParameters(queryParams);
                }
                request.setEntity(requestEntity);
                if (request.getClientInfo().getAcceptedCharacterSets().size() == 0 && request.getClientInfo().getAcceptedEncodings().size() == 0 && request.getClientInfo().getAcceptedLanguages().size() == 0 && request.getClientInfo().getAcceptedMediaTypes().size() == 0 && (responseVariants = annotationInfo.getResponseVariants(this.getClientResource().getMetadataService(), this.getClientResource().getConverterService())) != null) {
                    request.setClientInfo(new ClientInfo(responseVariants));
                }
                Response response = this.getClientResource().handleOutbound(request);
                if (isSynchronous) {
                    if (response.getStatus().isError()) {
                        this.getClientResource().doError(response.getStatus());
                    }
                    if (!annotationInfo.getJavaOutputType().equals(Void.TYPE)) {
                        result = this.getClientResource().toObject(response == null ? null : response.getEntity(), annotationInfo.getJavaOutputType());
                    }
                }
            }
        }
        return result;
    }
}

