/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public final class DOMTokenList
extends SimpleScriptable {
    private static final String WHITESPACE_CHARS = " \t\r\n\f";
    private String attributeName_;

    public DOMTokenList() {
    }

    public DOMTokenList(Node node, String attributeName) {
        this.setDomNode((DomNode)node.getDomNodeOrDie(), false);
        this.setParentScope(node.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributeName_ = attributeName;
    }

    @JsxGetter
    public int getLength() {
        Object value = this.getDefaultValue((Class)null);
        return StringUtils.split((String)value, WHITESPACE_CHARS).length;
    }

    @Override
    public String getDefaultValue(Class<?> hint) {
        DomAttr attr = (DomAttr)((DomNode)this.getDomNodeOrDie()).getAttributes().getNamedItem(this.attributeName_);
        if (attr != null) {
            String value = attr.getValue();
            return value;
        }
        return "";
    }

    @JsxFunction
    public void add(String token) {
        if (!this.contains(token)) {
            Object value = this.getDefaultValue((Class)null);
            if (((String)value).length() != 0 && !this.isWhitespache(((String)value).charAt(((String)value).length() - 1))) {
                value = (String)value + " ";
            }
            value = (String)value + token;
            this.updateAttribute((String)value);
        }
    }

    @JsxFunction
    public void remove(String token) {
        if (StringUtils.isEmpty(token)) {
            throw Context.reportRuntimeError("Empty imput not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, WHITESPACE_CHARS)) {
            throw Context.reportRuntimeError("Empty imput not allowed");
        }
        Object value = this.getDefaultValue((Class)null);
        int pos = this.position((String)value, token);
        while (pos != -1) {
            int from;
            int to = pos + token.length();
            for (from = pos; from > 0 && this.isWhitespache(((String)value).charAt(from - 1)); --from) {
            }
            while (to < ((String)value).length() - 1 && this.isWhitespache(((String)value).charAt(to))) {
                ++to;
            }
            StringBuilder result = new StringBuilder();
            if (from > 0) {
                result.append(((String)value).substring(0, from));
                result.append(" ");
            }
            result.append(((String)value).substring(to));
            value = result.toString();
            this.updateAttribute((String)value);
            pos = this.position((String)value, token);
        }
    }

    @JsxFunction
    public boolean toggle(String token) {
        if (this.contains(token)) {
            this.remove(token);
            return false;
        }
        this.add(token);
        return true;
    }

    @JsxFunction
    public boolean contains(String token) {
        if (StringUtils.isEmpty(token)) {
            throw Context.reportRuntimeError("Empty imput not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, WHITESPACE_CHARS)) {
            throw Context.reportRuntimeError("Empty imput not allowed");
        }
        return this.position((String)this.getDefaultValue((Class)null), token) > -1;
    }

    @JsxFunction
    public Object item(int index) {
        if (index < 0) {
            return null;
        }
        Object value = this.getDefaultValue((Class)null);
        List<String> values = Arrays.asList(StringUtils.split((String)value, WHITESPACE_CHARS));
        if (index < values.size()) {
            return values.get(index);
        }
        return null;
    }

    private void updateAttribute(String value) {
        HtmlElement domNode = (HtmlElement)this.getDomNodeOrDie();
        DomAttr attr = (DomAttr)domNode.getAttributes().getNamedItem(this.attributeName_);
        if (null == attr) {
            attr = domNode.getPage().createAttribute(this.attributeName_);
            domNode.setAttributeNode(attr);
        }
        attr.setValue(value);
    }

    private int position(String value, String token) {
        int pos = value.indexOf(token);
        if (pos < 0) {
            return -1;
        }
        if (pos != 0 && !this.isWhitespache(value.charAt(pos - 1))) {
            return -1;
        }
        int end = pos + token.length();
        if (end != value.length() && !this.isWhitespache(value.charAt(end))) {
            return -1;
        }
        return pos;
    }

    private boolean isWhitespache(int ch) {
        return WHITESPACE_CHARS.indexOf(ch) > -1;
    }
}

