/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.google.common.collect.Maps;
import com.thoughtworks.selenium.SeleniumException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;

public class Windows {
    private final Map<String, String> lastFrame = Maps.newHashMap();
    private final String originalWindowHandle;

    public Windows(WebDriver driver) {
        this.originalWindowHandle = driver.getWindowHandle();
    }

    public void selectWindow(WebDriver driver, String windowID) {
        if (windowID == null || "null".equals(windowID) || "".equals(windowID)) {
            driver.switchTo().window(this.originalWindowHandle);
        } else if ("_blank".equals(windowID)) {
            this.selectBlankWindow(driver);
        } else {
            if (windowID.startsWith("title=")) {
                this.selectWindowWithTitle(driver, windowID.substring("title=".length()));
                return;
            }
            if (windowID.startsWith("name=")) {
                windowID = windowID.substring("name=".length());
            }
            try {
                driver.switchTo().window(windowID);
            }
            catch (NoSuchWindowException noSuchWindowException) {
                this.selectWindowWithTitle(driver, windowID);
            }
        }
        if (this.lastFrame.containsKey(driver.getWindowHandle())) {
            try {
                this.selectFrame(driver, this.lastFrame.get(driver.getWindowHandle()));
            }
            catch (SeleniumException seleniumException) {
                this.lastFrame.remove(driver.getWindowHandle());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void selectPopUp(WebDriver driver, String windowID) {
        if ("null".equals(windowID) || "".equals(windowID)) {
            Set<String> windowHandles = driver.getWindowHandles();
            windowHandles.remove(this.originalWindowHandle);
            if (windowHandles.size() <= 0) throw new SeleniumException("Unable to find a popup window");
            driver.switchTo().window(windowHandles.iterator().next());
            return;
        } else {
            this.selectWindow(driver, windowID);
        }
    }

    public void selectFrame(WebDriver driver, String locator) {
        if ("relative=top".equals(locator)) {
            driver.switchTo().defaultContent();
            this.lastFrame.remove(driver.getWindowHandle());
            return;
        }
        if (locator.startsWith("index=")) {
            try {
                int index = Integer.parseInt(locator.substring("index=".length()));
                this.lastFrame.put(driver.getWindowHandle(), locator);
                driver.switchTo().frame(index);
                return;
            }
            catch (NumberFormatException e) {
                throw new SeleniumException(e.getMessage(), e);
            }
            catch (NoSuchFrameException e) {
                throw new SeleniumException(e.getMessage(), e);
            }
        }
        if (locator.startsWith("id=")) {
            locator = locator.substring("id=".length());
        } else if (locator.startsWith("name=")) {
            locator = locator.substring("name=".length());
        }
        try {
            this.lastFrame.put(driver.getWindowHandle(), locator);
            driver.switchTo().frame(locator);
        }
        catch (NoSuchFrameException e) {
            throw new SeleniumException(e.getMessage(), e);
        }
    }

    private void selectWindowWithTitle(WebDriver driver, String title) {
        String current = driver.getWindowHandle();
        for (String handle : driver.getWindowHandles()) {
            driver.switchTo().window(handle);
            if (!title.equals(driver.getTitle())) continue;
            return;
        }
        driver.switchTo().window(current);
        throw new SeleniumException("Unable to select window with title: " + title);
    }

    public void selectBlankWindow(WebDriver driver) {
        String current = driver.getWindowHandle();
        ArrayList<String> handles = new ArrayList<String>(driver.getWindowHandles());
        for (String handle : handles) {
            if (handle.equals(this.originalWindowHandle)) continue;
            driver.switchTo().window(handle);
            String value = (String)((JavascriptExecutor)((Object)driver)).executeScript("return window.name;", new Object[0]);
            if (value != null && !"".equals(value)) continue;
            return;
        }
        driver.switchTo().window(current);
        throw new SeleniumException("Unable to select window _blank");
    }
}

