/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.fn;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.HttpBufferedResponse;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.HtmlPageRenders;

public class JspFns {
    private static final Logger log = LoggerFactory.getLogger(JspFns.class);
    private static long LAST_MODIFIED = new Date().getTime();
    private static Boolean _shallETag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String outZkHtmlTags(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String deviceType) {
        Execution old = Executions.getCurrent();
        ExecutionImpl exec = new ExecutionImpl(ctx, request, response, null, null);
        ExecutionsCtrl.setCurrent(exec);
        ((ExecutionCtrl)exec).onActivate();
        try {
            String string = HtmlPageRenders.outZkTags(exec, WebManager.getWebManager(ctx).getWebApp(), deviceType != null ? deviceType : "ajax");
            return string;
        }
        finally {
            ((ExecutionCtrl)exec).onDeactivate();
            ExecutionsCtrl.setCurrent(old);
        }
    }

    public static String outDeviceCSSContent(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String deviceType) {
        StringWriter sw = new StringWriter();
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(deviceType)) {
            for (String uri : langdef.getCSSURIs()) {
                try {
                    Servlets.include((ServletContext)ctx, (ServletRequest)request, (ServletResponse)HttpBufferedResponse.getInstance((HttpServletResponse)response, (Writer)sw), (String)uri, null, (int)0);
                }
                catch (Throwable ex) {
                    log.error("Unable to load " + uri, ex);
                }
            }
        }
        return sw.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String outDeviceStyleSheets(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String deviceType) {
        Execution old = Executions.getCurrent();
        ExecutionImpl exec = new ExecutionImpl(ctx, request, response, null, null);
        ExecutionsCtrl.setCurrent(exec);
        ((ExecutionCtrl)exec).onActivate();
        try {
            String string = HtmlPageRenders.outLangStyleSheets(exec, WebManager.getWebManager(ctx).getWebApp(), deviceType != null ? deviceType : "ajax");
            return string;
        }
        finally {
            ((ExecutionCtrl)exec).onDeactivate();
            ExecutionsCtrl.setCurrent(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String outDeviceJavaScripts(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String deviceType) {
        Execution old = Executions.getCurrent();
        ExecutionImpl exec = new ExecutionImpl(ctx, request, response, null, null);
        ExecutionsCtrl.setCurrent(exec);
        ((ExecutionCtrl)exec).onActivate();
        try {
            String string = HtmlPageRenders.outLangJavaScripts(exec, WebManager.getWebManager(ctx).getWebApp(), deviceType != null ? deviceType : "ajax");
            return string;
        }
        finally {
            ((ExecutionCtrl)exec).onDeactivate();
            ExecutionsCtrl.setCurrent(old);
        }
    }

    public static void setCacheControl(HttpServletResponse response, String prop, int hours) {
        if (prop == null || !"false".equals(Library.getProperty((String)prop))) {
            response.setHeader("Cache-Control", "public, max-age=" + hours * 3600);
            Calendar cal = Calendar.getInstance();
            cal.add(10, hours);
            response.setDateHeader("Expires", cal.getTime().getTime());
            response.setDateHeader("Last-Modified", LAST_MODIFIED);
        }
    }

    public static boolean setCacheControl(ServletContext context, HttpServletRequest request, HttpServletResponse response, String prop, int hours) {
        if (prop == null || !"false".equals(Library.getProperty((String)prop))) {
            response.setHeader("Cache-Control", "public, max-age=" + hours * 3600);
            Calendar cal = Calendar.getInstance();
            cal.add(10, hours);
            response.setDateHeader("Expires", cal.getTime().getTime());
            response.setDateHeader("Last-Modified", LAST_MODIFIED);
            if (JspFns.shallETag()) {
                String etag = WebManager.getWebManager(context).getClassWebResource().getEncodeURLPrefix();
                String inm = request.getHeader("If-None-Match");
                if (inm != null && inm.equals(etag)) {
                    response.setStatus(304);
                    response.setHeader("ETag", etag);
                    request.setAttribute("ETagMatched", (Object)Boolean.TRUE);
                    return true;
                }
                response.setHeader("ETag", etag);
            }
        }
        return false;
    }

    private static final boolean shallETag() {
        if (_shallETag == null) {
            String s = Library.getProperty((String)"org.zkoss.web.classWebResource.cache.etag");
            _shallETag = "true".equals(s);
        }
        return _shallETag;
    }

    public static void setCSSCacheControl(HttpServletResponse response) {
        JspFns.setCSSCacheControl(null, null, response);
    }

    public static boolean setCSSCacheControl(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        int hours = 8760;
        String PROP = "org.zkoss.web.classWebResource.cache.CSS.hours";
        String s = Library.getProperty((String)"org.zkoss.web.classWebResource.cache.CSS.hours");
        if (s != null) {
            try {
                hours = Integer.parseInt(s);
                if (hours <= 0) {
                    return false;
                }
            }
            catch (Throwable ex) {
                log.warn("Ingored property org.zkoss.web.classWebResource.cache.CSS.hours: an integer is expected");
            }
        }
        if (context != null) {
            return JspFns.setCacheControl(context, request, response, "org.zkoss.web.classWebResource.cache", hours);
        }
        JspFns.setCacheControl(response, "org.zkoss.web.classWebResource.cache", hours);
        return false;
    }

    public static void setCWRCacheControl(HttpServletResponse response) {
        JspFns.setCacheControl(response, "org.zkoss.web.classWebResource.cache", 8760);
    }

    public static boolean setCWRCacheControl(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        return JspFns.setCacheControl(context, request, response, "org.zkoss.web.classWebResource.cache", 8760);
    }
}

