/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.zkoss.io.Serializables;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.ComponentSerializationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventListenerInfo
implements ComponentSerializationListener,
ComponentActivationListener,
Serializable {
    final int priority;
    final EventListener<? extends Event> listener;

    EventListenerInfo(int priority, EventListener<? extends Event> listener) {
        this.priority = priority;
        this.listener = listener;
    }

    static final void write(ObjectOutputStream s, AbstractComponent comp, Map<String, List<EventListenerInfo>> listeners) throws IOException {
        if (listeners != null) {
            Logger logio = Serializables.logio;
            boolean debug = logio.isDebugEnabled();
            for (Map.Entry<String, List<EventListenerInfo>> me : listeners.entrySet()) {
                boolean keyWritten = false;
                List<EventListenerInfo> ls = me.getValue();
                for (EventListenerInfo li : ls) {
                    if (comp != null) {
                        comp.willSerialize(li.listener);
                    }
                    if (li.listener instanceof Serializable || li.listener instanceof Externalizable) {
                        if (!keyWritten) {
                            keyWritten = true;
                            s.writeObject(me.getKey());
                        }
                        try {
                            s.writeObject(li);
                            continue;
                        }
                        catch (NotSerializableException ex) {
                            logio.error("Unable to serialize item: " + li.listener);
                            throw ex;
                        }
                    }
                    if (!debug) continue;
                    logio.debug("Skip not-serializable item: " + li.listener);
                }
                if (!keyWritten) continue;
                s.writeObject(null);
            }
        }
        s.writeObject(null);
    }

    static final Map<String, List<EventListenerInfo>> read(ObjectInputStream s, AbstractComponent comp) throws IOException, ClassNotFoundException {
        String evtnm;
        HashMap<String, List> listeners = null;
        while ((evtnm = (String)s.readObject()) != null) {
            List ls;
            if (listeners == null) {
                listeners = new HashMap<String, List>(4);
            }
            if ((ls = Serializables.smartRead((ObjectInputStream)s, (List)null)) == null) continue;
            if (comp != null) {
                for (EventListenerInfo li : ls) {
                    comp.didDeserialize(li.listener);
                }
            }
            listeners.put(evtnm, ls);
        }
        return listeners;
    }

    @Override
    public void willSerialize(Component comp) {
        ((AbstractComponent)comp).willSerialize(this.listener);
    }

    @Override
    public void didDeserialize(Component comp) {
        ((AbstractComponent)comp).didDeserialize(this.listener);
    }

    @Override
    public void didActivate(Component comp) {
        ((AbstractComponent)comp).didActivate(this.listener);
    }

    @Override
    public void willPassivate(Component comp) {
        ((AbstractComponent)comp).willPassivate(this.listener);
    }

    public String toString() {
        return "[" + this.priority + ": " + this.listener.toString() + "]";
    }
}

