/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zkoss.util.CollectionsX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.util.ForEach;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.EvaluatorRef;
import org.zkoss.zk.xel.ExValue;

public class ForEachImpl
implements ForEach {
    private final EvaluatorRef _evalr;
    private final Page _page;
    private final Component _comp;
    private final ExValue[] _expr;
    private final ExValue _begin;
    private final ExValue _end;
    private Status _status;
    private Iterator _it;
    private Object _oldEach;
    private boolean _done;

    public static ForEach getInstance(EvaluatorRef evalr, Component comp, ExValue[] expr, ExValue begin, ExValue end) {
        if (expr == null || expr.length == 0) {
            return null;
        }
        return new ForEachImpl(evalr, comp, expr, begin, end);
    }

    public static ForEach getInstance(EvaluatorRef evalr, Page page, ExValue[] expr, ExValue begin, ExValue end) {
        if (expr == null || expr.length == 0) {
            return null;
        }
        return new ForEachImpl(evalr, page, expr, begin, end);
    }

    public ForEachImpl(EvaluatorRef evalr, Component comp, ExValue[] expr, ExValue begin, ExValue end) {
        if (comp == null || evalr == null) {
            throw new IllegalArgumentException("null");
        }
        this._evalr = evalr;
        this._page = null;
        this._comp = comp;
        this._expr = expr;
        this._begin = begin;
        this._end = end;
    }

    public ForEachImpl(EvaluatorRef evalr, Page page, ExValue[] expr, ExValue begin, ExValue end) {
        if (page == null || evalr == null) {
            throw new IllegalArgumentException();
        }
        this._evalr = evalr;
        this._page = page;
        this._comp = null;
        this._expr = expr;
        this._begin = begin;
        this._end = end;
    }

    public static ForEach getInstance(EvaluatorRef evalr, Component comp, String expr, String begin, String end) {
        if (expr == null || expr.length() == 0) {
            return null;
        }
        return new ForEachImpl(evalr, comp, expr, begin, end);
    }

    public static ForEach getInstance(EvaluatorRef evalr, Page page, String expr, String begin, String end) {
        if (expr == null || expr.length() == 0) {
            return null;
        }
        return new ForEachImpl(evalr, page, expr, begin, end);
    }

    public ForEachImpl(EvaluatorRef evalr, Component comp, String expr, String begin, String end) {
        ExValue[] exValueArray;
        if (comp == null || evalr == null) {
            throw new IllegalArgumentException();
        }
        this._evalr = evalr;
        this._page = null;
        this._comp = comp;
        if (expr != null) {
            ExValue[] exValueArray2 = new ExValue[1];
            exValueArray = exValueArray2;
            exValueArray2[0] = new ExValue(expr, Object.class);
        } else {
            exValueArray = null;
        }
        this._expr = exValueArray;
        this._begin = begin != null && begin.length() > 0 ? new ExValue(begin, Integer.class) : null;
        this._end = end != null && end.length() > 0 ? new ExValue(end, Integer.class) : null;
    }

    public ForEachImpl(EvaluatorRef evalr, Page page, String expr, String begin, String end) {
        ExValue[] exValueArray;
        if (page == null || evalr == null) {
            throw new IllegalArgumentException();
        }
        this._evalr = evalr;
        this._page = page;
        this._comp = null;
        if (expr != null) {
            ExValue[] exValueArray2 = new ExValue[1];
            exValueArray = exValueArray2;
            exValueArray2[0] = new ExValue(expr, Object.class);
        } else {
            exValueArray = null;
        }
        this._expr = exValueArray;
        this._begin = begin != null && begin.length() > 0 ? new ExValue(begin, Integer.class) : null;
        this._end = end != null && end.length() > 0 ? new ExValue(end, Integer.class) : null;
    }

    private Object eval(ExValue value) {
        return value == null ? null : (this._comp != null ? value.getValue((Evaluator)this._evalr, this._comp) : value.getValue((Evaluator)this._evalr, this._page));
    }

    public boolean next() {
        if (this._done) {
            throw new IllegalStateException("Iterate twice not allowed");
        }
        if (this._status == null) {
            int vbeg;
            Object[] o;
            if (this._expr == null || this._expr.length == 0) {
                o = null;
            } else if (this._expr.length == 1) {
                o = this.eval(this._expr[0]);
            } else {
                Object[] ary = new Object[this._expr.length];
                for (int j = 0; j < this._expr.length; ++j) {
                    ary[j] = this.eval(this._expr[j]);
                }
                o = ary;
            }
            if (o == null) {
                this._done = true;
                return false;
            }
            this.setupStatus();
            Integer ibeg = (Integer)this.eval(this._begin);
            int n = vbeg = ibeg != null ? ibeg : 0;
            if (vbeg < 0) {
                vbeg = 0;
                ibeg = new Integer(0);
            }
            this._status.setBegin(ibeg);
            this._status.setEnd((Integer)this.eval(this._end));
            this.prepare(o, vbeg);
        }
        if ((this._status.end == null || this._status.index < this._status.end) && this._it.hasNext()) {
            ++this._status.index;
            this._status.each = this._it.next();
            this.getScope().setAttribute("each", this._status.each);
            return true;
        }
        this._done = true;
        this.restoreStatus();
        return false;
    }

    private void setupStatus() {
        Scope scope = this.getScope();
        this._oldEach = scope.getAttribute("each", true);
        this._status = new Status(scope.getAttribute("forEachStatus", true));
        scope.setAttribute("forEachStatus", this._status);
    }

    private void restoreStatus() {
        Scope scope = this.getScope();
        if (this._status.previous != null) {
            scope.setAttribute("forEachStatus", this._status.previous);
        } else {
            scope.removeAttribute("forEachStatus");
        }
        if (this._oldEach != null) {
            scope.setAttribute("each", this._oldEach);
        } else {
            scope.removeAttribute("each");
        }
        this._it = null;
        this._status = null;
    }

    private Scope getScope() {
        return this._comp != null ? this._comp : this._page;
    }

    private void prepare(Object o, final int begin) {
        if (begin > 0 && o instanceof List) {
            List l;
            int size = (l = (List)o).size();
            this._it = l.listIterator(begin > size ? size : begin);
        } else if (o instanceof Collection) {
            this._it = ((Collection)o).iterator();
            this.forward(begin);
        } else if (o instanceof Map) {
            this._it = ((Map)o).entrySet().iterator();
            this.forward(begin);
        } else if (o instanceof Iterator) {
            this._it = (Iterator)o;
            this.forward(begin);
        } else if (o instanceof Enumeration) {
            this._it = new CollectionsX.EnumerationIterator((Enumeration)o);
            this.forward(begin);
        } else if (o instanceof Object[]) {
            final Object[] ary = (Object[])o;
            this._it = new Iterator(){
                private int _j;
                {
                    this._j = begin;
                }

                public boolean hasNext() {
                    return this._j < ary.length;
                }

                public Object next() {
                    return ary[this._j++];
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        } else if (o instanceof int[]) {
            final int[] ary = (int[])o;
            this._it = new Iterator(){
                private int _j;
                {
                    this._j = begin;
                }

                public boolean hasNext() {
                    return this._j < ary.length;
                }

                public Object next() {
                    return new Integer(ary[this._j++]);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        } else if (o instanceof long[]) {
            final long[] ary = (long[])o;
            this._it = new Iterator(){
                private int _j;
                {
                    this._j = begin;
                }

                public boolean hasNext() {
                    return this._j < ary.length;
                }

                public Object next() {
                    return new Long(ary[this._j++]);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        } else if (o instanceof short[]) {
            final short[] ary = (short[])o;
            this._it = new Iterator(){
                private int _j;
                {
                    this._j = begin;
                }

                public boolean hasNext() {
                    return this._j < ary.length;
                }

                public Object next() {
                    return new Short(ary[this._j++]);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        } else if (o instanceof byte[]) {
            final byte[] ary = (byte[])o;
            this._it = new Iterator(){
                private int _j;
                {
                    this._j = begin;
                }

                public boolean hasNext() {
                    return this._j < ary.length;
                }

                public Object next() {
                    return new Byte(ary[this._j++]);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        } else if (o instanceof double[]) {
            final double[] ary = (double[])o;
            this._it = new Iterator(){
                private int _j;
                {
                    this._j = begin;
                }

                public boolean hasNext() {
                    return this._j < ary.length;
                }

                public Object next() {
                    return new Double(ary[this._j++]);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        } else if (o instanceof float[]) {
            final float[] ary = (float[])o;
            this._it = new Iterator(){
                private int _j;
                {
                    this._j = begin;
                }

                public boolean hasNext() {
                    return this._j < ary.length;
                }

                public Object next() {
                    return new Float(ary[this._j++]);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        } else if (o instanceof char[]) {
            final char[] ary = (char[])o;
            this._it = new Iterator(){
                private int _j;
                {
                    this._j = begin;
                }

                public boolean hasNext() {
                    return this._j < ary.length;
                }

                public Object next() {
                    return new Character(ary[this._j++]);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        } else if (o instanceof boolean[]) {
            final boolean[] ary = (boolean[])o;
            this._it = new Iterator(){
                private int _j;
                {
                    this._j = begin;
                }

                public boolean hasNext() {
                    return this._j < ary.length;
                }

                public Object next() {
                    return ary[this._j++];
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        } else {
            this._it = new CollectionsX.OneIterator(o);
            this.forward(begin);
        }
    }

    private void forward(int begin) {
        while (--begin >= 0 && this._it.hasNext()) {
            this._it.next();
        }
    }

    private static class Status
    implements ForEachStatus {
        private final Object previous;
        private Object each;
        private int index;
        private Integer begin;
        private Integer end;

        private Status(Object previous) {
            this.previous = previous;
            this.index = -1;
        }

        private void setBegin(Integer begin) {
            this.begin = begin;
            this.index = begin != null ? begin - 1 : -1;
        }

        private void setEnd(Integer end) {
            this.end = end;
        }

        public ForEachStatus getPrevious() {
            return this.previous instanceof ForEachStatus ? (ForEachStatus)this.previous : null;
        }

        public Object getEach() {
            return this.each;
        }

        public int getIndex() {
            return this.index;
        }

        public Integer getBegin() {
            return this.begin;
        }

        public Integer getEnd() {
            return this.end;
        }

        public String toString() {
            return "[index=" + this.index + ']';
        }
    }
}

