

zk.Event = zk.$extends(zk.Object, {
	
	
	
 	
 	
 	
 	
 	
 	
 	
 	
 	
 	
 	
 	
 	
 	
 	
 	
 	

	
	$init: function (target, name, data, opts, domEvent) {
		this.currentTarget = this.target = target;
		this.name = name;
		this.data = data;
		if (data && typeof data == 'object' && !jq.isArray(data))
			zk.$default(this, data);

		this.opts = opts||{rtags:{}};
		if (this.domEvent = domEvent)
			this.domTarget = domEvent.target;
	},
	
	addOptions: function (opts) {
		this.opts = zk.copy(this.opts, opts);
	},
	
	stop: function (opts) {
		var b = !opts || !opts.revoke;
		if (!opts || opts.propagation) this.stopped = b;
		if (!opts || opts.dom) this.domStopped = b;
		if (opts && opts.au) this.auStopped = b;
	}
});

zWatch = (function () {
	var _visiEvts = {onFitSize: true, onSize: true, onShow: true, onHide: true, beforeSize: true},
		_watches = {}, 
		_dirty,
		_Gun = zk.$extends(zk.Object, {
			$init: function (name, xinfs, args, org, fns) {
				this.name = name;
				this.xinfs = xinfs;
				this.args = args;
				this.origin = org;
				this.fns = fns;
			},
			fire: function (ref) {
				var infs, inf, xinf,
					name = this.name,
					xinfs = this.xinfs,
					args = this.args,
					fns = this.fns;
				if (ref) {
					for (var j = 0, l = xinfs.length; j < l; ++j)
						if (xinfs[j][0] == ref) {
							infs = xinfs[j][1]
							xinfs.splice(j--, 1);
							--l;
							_invoke(name, infs, ref, args, fns);
						}
				} else
					while (xinf = xinfs.shift())
						_invoke(name, xinf[1], xinf[0], args, fns);
			},
			fireDown: function (ref) {
				if (!ref || ref.bindLevel == null)
					this.fire(ref);

				(new _Gun(this.name, _visiChildSubset(this.name, this.xinfs, ref, true), this.args, this.origin, this.fns))
				.fire();
			}
		});

	function _invoke(name, infs, o, args, fns) {
		for (var j = 0, l = infs.length; j < l;) {
			var f = _fn(infs[j++], o, name);
			if (fns)
				fns.push([f, o]); 
			else
				f.apply(o, args);
		}
		if (name == 'onSize') { 
			var after = o['onAfterSize'];
			if (after)
				after.apply(o, args);
		}
	}
	
	function _visible(name, c) {
		return c.isWatchable_ && c.isWatchable_(name); 
	}
	
	function _visibleChild(name, p, c, cache) {
		for (var w = c; w; w = w.parent)
			if (p == w) 
				return !cache || c.isWatchable_(name, p, cache);
		return false;
	}
	
	function _visiChildSubset(name, xinfs, p, remove) {
		var found = [], bindLevel = p.bindLevel,
			cache = _visiEvts[name] && {}, pvisible;
		if (p.isWatchable_) 
			for (var j = xinfs.length; j--;) {
				var xinf = xinfs[j],
					o = xinf[0],
					diff = bindLevel > o.bindLevel;
				if (diff) 
					break;

				if (!pvisible && cache) { 
					if (!(pvisible = _visible(name, p))) 
						break; 
					cache[p.uuid] = true; 
				}

				if (_visibleChild(name, p, o, cache)) {
					if (remove)
						xinfs.splice(j, 1);
					found.unshift(xinf); 
				}
			}
		return found;
	}
	function _visiSubset(name, xinfs) {
		xinfs = xinfs.$clone(); 
		if (_visiEvts[name])
			for (var j = xinfs.length; j--;)
				if (!_visible(name, xinfs[j][0]))
					xinfs.splice(j, 1);
		return xinfs;
	}
	function _target(inf) {
		return jq.isArray(inf) ? inf[0]: inf;
	}
	function _fn(inf, o, name) {
		var fn = jq.isArray(inf) ? inf[1]: o[name];
		if (!fn)
			throw (o.className || o) + ':' + name + ' not found';
		return fn;
	}
	function _sync() {
		if (!_dirty) return;

		_dirty = false;
		for (var nm in _watches) {
			var wts = _watches[nm];
			if (wts.length && wts[0][0].bindLevel != null)
				wts.sort(_cmpLevel);
		}
	}
	function _bindLevel(a) {
		return (a = a.bindLevel) == null || isNaN(a) ? -1: a;
	}
	function _cmpLevel(a, b) {
		return _bindLevel(a[0]) - _bindLevel(b[0]);
	}
	zk._zsyncFns = function (name, org) {
		if (name == 'onSize' || name == 'onShow' || name == 'onHide') {
			jq.zsync(org);
			if (name == 'onSize')
                setTimeout('zk.doAfterResize()', 20); 
		}
		if (name == 'onResponse')
			jq.doSyncScroll();
	};
	
	function _reversefns(fns, args) {
		if (fns)
			
			
			
			for (var j = fns.length, k = j - 1, i, f, oldp, newp; j >= 0;) {
				if (--j < 0 || (oldp != (newp=fns[j][1].parent) && oldp)) {
					for (i = j; ++i <= k;) {
						f = fns[i];
						f[0].apply(f[1], args);
					}
					k = j;
				}
				oldp = newp;
			}
	}
	function _fire(name, org, opts, vararg) {
		var wts = _watches[name];
		if (wts && wts.length) {
			var down = opts && opts.down && org.bindLevel != null;
			if (down) _sync();

			var args = [],
				fns = opts && opts.reverse ? []: null,
				gun = new _Gun(name,
					down ? _visiChildSubset(name, wts, org): _visiSubset(name, wts),
					args, org, fns);
			args.push(gun);
			for (var j = 2, l = vararg.length; j < l;) 
				args.push(vararg[j++]);

			if (opts && opts.timeout >= 0)
				setTimeout(function () {
					gun.fire();
					_reversefns(fns, args);
					zk._zsyncFns(name, org);
				}, opts.timeout);
			else {
				gun.fire();
				_reversefns(fns, args);
				zk._zsyncFns(name, org);
			}
		} else
			zk._zsyncFns(name, org);
	}
	
	function _isListened(wts, inf) {
		if (wts) {
			if (jq.isArray(inf)) {
				var isListen = false;
				for (var i = wts.length; i > 0; i--) {
					if (jq.isArray(wts[i]) && wts[i].$equals(inf)) {
						isListen = true;
						break;
					}
				}
				return isListen;
			}
			return wts.$contains(inf);
		}
		return false;
	}


  return {
  	
	listen: function (infs) {
		for (var name in infs) {
			var wts = _watches[name],
				inf = infs[name],
				o = _target(inf),
				xinf = [o, [inf]];
			if (wts) {
				var bindLevel = o.bindLevel;
				if (bindLevel != null) {
					for (var j = wts.length;;) {
						if (--j < 0) {
							wts.unshift(xinf);
							break;
						}
						if (wts[j][0] == o) {
							if (!_isListened(wts[j][1], inf)) 
								wts[j][1].push(inf);
							break;
						}
						if (bindLevel >= wts[j][0].bindLevel) { 
							wts.splice(j + 1, 0, xinf);
							break;
						}
					}
				} else
					for (var j = wts.length;;) {
						if (--j < 0) {
							wts.push(xinf);
							break;
						}
						if (wts[j][0] == o) {
							wts[j][1].push(inf);
							break;
						}
					}
			} else {
				_watches[name] = [xinf];
			}
		}
	},
	
	unlisten: function (infs) {
		for (var name in infs) {
			var wts = _watches[name];
			if (wts) {
				var inf = infs[name],
					o = _target(inf);
				for (var j = wts.length; j--;)
					if (wts[j][0] == o) {
						wts[j][1].$remove(inf);
						if (!wts[j][1].length)
							wts.splice(j, 1);
						break;
					}
			}
		}
	},
	
	unlistenAll: function (name) {
		delete _watches[name];
	},
	
	fire: function (name, org, opts) {
		_fire(name, org, opts, arguments);
	},
	
	fireDown: function (name, org, opts) {
		_fire(name, org, zk.copy(opts,{down:true}), arguments);
	},
	onBindLevelMove: function () { 
		_dirty = true;
	}
  };
})();
zWatch.listen({onBindLevelMove: zWatch});
