/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.util.Properties;
import oracle.net.ano.Ano;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.resolver.AddrResolution;

public abstract class NSProtocol
implements Communication,
SQLnetDef {
    protected AddrResolution addrRes;
    protected SessionAtts sAtts;
    private static final boolean ACTIVATE_ANO = true;
    boolean ACTIVATE_ANO_NIO = true;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    @Override
    public SessionAtts getSessionAttributes() {
        return this.sAtts;
    }

    @Override
    public void connect(String string, Properties properties) throws IOException, NetException {
        if (this.sAtts.connected) {
            throw new NetException(201);
        }
        if (string == null) {
            throw new NetException(208);
        }
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        Object var5_5 = null;
        Object var6_6 = null;
        this.addrRes = new AddrResolution(string, properties);
        String string2 = (String)properties.get("DISABLE_OOB");
        boolean bl = string2 != null && "true".equals(string2);
        String string3 = (String)properties.get("USE_ZERO_COPY_IO");
        boolean bl2 = true;
        if (string3 != null && "false".equals(string3)) {
            bl2 = false;
        }
        this.sAtts.traceId = (String)properties.get("T4CConnection.hashCode");
        if (this.addrRes.connection_revised) {
            string = this.addrRes.getTNSAddress();
            properties = this.addrRes.getUp();
        }
        this.sAtts.profile = new ClientProfile(properties);
        this.establishConnection(string);
        Object var11_11 = null;
        if (this.ACTIVATE_ANO_NIO) {
            try {
                var11_11 = Class.forName("oracle.net.ano.Ano").newInstance();
                this.sAtts.anoEnabled = true;
            }
            catch (Exception exception) {
                this.sAtts.anoEnabled = false;
            }
            if (var11_11 != null) {
                ((Ano)var11_11).init(this.sAtts);
                this.sAtts.ano = var11_11;
                this.sAtts.anoEnabled = true;
            }
        }
        this.negotiateConnection(nVFactory, nVNavigator, bl, bl2);
        this.sAtts.connected = true;
        this.sAtts.nt.setReadTimeoutIfRequired(properties);
        String string4 = (String)this.sAtts.nt.getOption(6);
        if (string4 != null && string4.equalsIgnoreCase("false")) {
            throw new NetException(405);
        }
        if (this.ACTIVATE_ANO_NIO && !this.sAtts.noAnoServices && this.sAtts.ano != null) {
            this.sAtts.ano.negotiation(this.addrRes.connection_redirected);
            String string5 = (String)this.sAtts.nt.getOption(2);
            if (string5 != null && string5.equals("TRUE")) {
                try {
                    Method method = this.sAtts.ano.getClass().getMethod("getEncryptionAlg", null);
                    if (method.invoke((Object)this.sAtts.ano, (Object[])null) != null) {
                        throw new NetException(406);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.addrRes.connection_redirected = false;
    }

    abstract void negotiateConnection(NVFactory var1, NVNavigator var2, boolean var3, boolean var4) throws IOException, NetException;

    @Override
    public void sendBreak() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(1);
            }
        } else {
            this.sendMarker(1);
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(3);
            }
        } else {
            this.sendMarker(3);
        }
    }

    protected abstract void sendMarker(int var1) throws IOException, NetException;

    @Override
    public void setOption(int n2, Object object) throws NetException, IOException {
        if (n2 > 0 && n2 < 10) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            nTAdapter.setOption(n2, object);
        }
    }

    @Override
    public Object getOption(int n2) throws NetException, IOException {
        if (n2 > 0 && n2 < 10) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            return nTAdapter.getOption(n2);
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        if (nTAdapter != null) {
            nTAdapter.abort();
        }
    }

    @Override
    public String getEncryptionName() {
        String string = null;
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        try {
            string = (String)nTAdapter.getOption(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null && this.sAtts.ano != null) {
            string = this.sAtts.ano.getEncryptionName();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public String getDataIntegrityName() {
        String string = "";
        if (this.sAtts.ano != null) {
            string = this.sAtts.ano.getDataIntegrityName();
        }
        return string;
    }

    @Override
    public String getAuthenticationAdaptorName() {
        String string = "";
        if (this.sAtts.ano != null) {
            string = this.sAtts.ano.getAuthenticationAdaptorName();
        }
        return string;
    }

    public void reconnectIfRequired(boolean bl) throws IOException {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.sAtts.timestampLastIO;
        if (l3 > (long)this.sAtts.timeout) {
            this.reconnect(bl);
        }
    }

    @Override
    public void setO3logSessionKey(byte[] byArray) throws NetException {
        if (byArray != null && this.ACTIVATE_ANO_NIO) {
            this.sAtts.ano.setO3logSessionKey(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(boolean bl) throws IOException {
        try {
            String string = new String(this.sAtts.reconnectAddress);
            this.sAtts.attemptingReconnect = true;
            ConnOption connOption = this.sAtts.cOption;
            this.addrRes.connection_redirected = true;
            this.sAtts.cOption.nt.disconnect();
            this.establishConnection(string);
            this.sAtts.cOption.restoreFromOrigCoption(connOption);
            if (bl) {
                this.sendProbePacket();
            }
        }
        finally {
            this.sAtts.attemptingReconnect = false;
        }
    }

    SessionAtts establishConnection(String string) throws NetException, IOException {
        this.sAtts.cOption = this.addrRes.resolveAndExecute(string);
        if (this.sAtts.cOption == null) {
            return null;
        }
        this.sAtts.nt = this.sAtts.cOption.nt;
        this.sAtts.setTDU(this.sAtts.cOption.tdu);
        this.sAtts.setSDU(this.sAtts.cOption.sdu);
        this.initializeSessionAttributes();
        return this.sAtts;
    }

    abstract void initializeSessionAttributes() throws NetException, IOException;

    abstract void sendProbePacket() throws IOException;

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.addrRes.isConnectionSocketKeepAlive();
    }

    @Override
    public int getSocketReadTimeout() throws NetException, IOException {
        String string = (String)this.getOption(3);
        int n2 = string == null || "".equals(string) ? 0 : Integer.parseInt(string);
        return n2;
    }

    @Override
    public void setSocketReadTimeout(int n2) throws NetException, IOException {
        String string = Integer.toString(n2);
        this.setOption(3, string);
    }

    @Override
    public String getConnectionString() {
        return this.addrRes.getTNSAddress();
    }

    @Override
    public int getNegotiatedSDU() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.negotiatedSDU;
    }
}

