/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuAlert;
import org.zkoss.zk.au.out.AuClearBusy;
import org.zkoss.zk.au.out.AuClearWrongValue;
import org.zkoss.zk.au.out.AuConfirmClose;
import org.zkoss.zk.au.out.AuLog;
import org.zkoss.zk.au.out.AuMoveBy;
import org.zkoss.zk.au.out.AuMoveTo;
import org.zkoss.zk.au.out.AuNotification;
import org.zkoss.zk.au.out.AuPrint;
import org.zkoss.zk.au.out.AuResizeBy;
import org.zkoss.zk.au.out.AuResizeTo;
import org.zkoss.zk.au.out.AuResizeWidget;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.au.out.AuScrollBy;
import org.zkoss.zk.au.out.AuScrollIntoView;
import org.zkoss.zk.au.out.AuScrollTo;
import org.zkoss.zk.au.out.AuShowBusy;
import org.zkoss.zk.au.out.AuSubmitForm;
import org.zkoss.zk.au.out.AuWrongValue;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clients {
    public static final String NOTIFICATION_TYPE_INFO = "info";
    public static final String NOTIFICATION_TYPE_WARNING = "warning";
    public static final String NOTIFICATION_TYPE_ERROR = "error";

    public static final void response(AuResponse response) {
        Executions.getCurrent().addAuResponse(response);
    }

    public static final void response(String key, AuResponse response) {
        Executions.getCurrent().addAuResponse(key, response);
    }

    public static final void confirmClose(String mesg) {
        Clients.response(new AuConfirmClose(mesg));
    }

    public static final void alert(String msg) {
        Clients.response(new AuAlert(msg));
    }

    public static final void alert(String msg, String title, String icon) {
        Clients.response(new AuAlert(msg, title, icon));
    }

    public static final void wrongValue(Component comp, String msg) {
        Clients.response(new AuWrongValue(comp, msg));
    }

    public static final void clearWrongValue(Component comp) {
        Clients.response(new AuClearWrongValue(comp));
    }

    public static final void clearWrongValue(List<Component> comps) {
        Clients.response(new AuClearWrongValue(comps));
    }

    public static final void clearWrongValue(Component[] comps) {
        Clients.response(new AuClearWrongValue(comps));
    }

    public static final void submitForm(String formId) {
        Clients.response(new AuSubmitForm(formId));
    }

    public static final void submitForm(Component form) {
        Clients.submitForm(form.getUuid());
    }

    public static void print() {
        Clients.response(new AuPrint());
    }

    public static final void scrollIntoView(Component cmp) {
        Clients.response(new AuScrollIntoView(cmp));
    }

    public static final void scrollBy(int x, int y) {
        Clients.response(new AuScrollBy(x, y));
    }

    public static final void scrollTo(int x, int y) {
        Clients.response(new AuScrollTo(x, y));
    }

    public static final void resizeBy(int x, int y) {
        Clients.response(new AuResizeBy(x, y));
    }

    public static final void resizeTo(int x, int y) {
        Clients.response(new AuResizeTo(x, y));
    }

    public static final void moveBy(int x, int y) {
        Clients.response(new AuMoveBy(x, y));
    }

    public static final void moveTo(int x, int y) {
        Clients.response(new AuMoveTo(x, y));
    }

    public static final void evalJavaScript(String javaScript) {
        Clients.response(new AuScript(null, javaScript));
    }

    public static final void showNotification(String msg) {
        Clients.showNotification(msg, null, null, null, -1, false);
    }

    public static final void showNotification(String msg, boolean closable) {
        Clients.showNotification(msg, null, null, null, -1, closable);
    }

    public static final void showNotification(String msg, Component ref) {
        Clients.showNotification(msg, null, ref, null, -1, false);
    }

    public static final void showNotification(String msg, Component ref, boolean closable) {
        Clients.showNotification(msg, null, ref, null, -1, closable);
    }

    public static final void showNotification(String msg, String type, Component ref, String position, int duration) {
        Clients.showNotification(msg, type, ref, position, duration, false);
    }

    public static final void showNotification(String msg, String type, Component ref, String position, int duration, boolean closable) {
        Page page;
        Execution exec = Executions.getCurrent();
        Page page2 = page = ref != null ? ref.getPage() : null;
        if (page == null && exec instanceof ExecutionCtrl) {
            page = ((ExecutionCtrl)((Object)exec)).getCurrentPage();
        }
        if (type == null) {
            type = NOTIFICATION_TYPE_INFO;
        }
        Clients.response(new AuNotification(msg, type, page, ref, position, duration, closable));
    }

    public static final void showNotification(String msg, String type, Component ref, int x, int y, int duration) {
        Clients.showNotification(msg, type, ref, x, y, duration, false);
    }

    public static final void showNotification(String msg, String type, Component ref, int x, int y, int duration, boolean closable) {
        Page page;
        Execution exec = Executions.getCurrent();
        Page page2 = page = ref != null ? ref.getPage() : null;
        if (page == null && exec instanceof ExecutionCtrl) {
            page = ((ExecutionCtrl)((Object)exec)).getCurrentPage();
        }
        if (type == null) {
            type = NOTIFICATION_TYPE_INFO;
        }
        Clients.response(new AuNotification(msg, type, page, ref, x, y, duration, closable));
    }

    public static final void showBusy(String msg) {
        Clients.response(new AuShowBusy(msg));
    }

    public static final void clearBusy() {
        Clients.response(new AuClearBusy());
    }

    public static final void showBusy(Component comp, String msg) {
        Clients.response(new AuShowBusy(comp, msg));
    }

    public static final void clearBusy(Component comp) {
        Clients.response(new AuClearBusy(comp));
    }

    public static final void resize(Component comp) {
        Clients.response(new AuResizeWidget(comp));
    }

    public static final void reloadMessages(Locale locale) throws IOException {
        Executions.getCurrent().getDesktop().getDevice().reloadMessages(locale);
    }

    public static final void log(String msg) {
        Clients.response(new AuLog(msg));
    }
}

