/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.ConventionWire;

public class ConventionWires {
    private static final Logger log = LoggerFactory.getLogger(ConventionWires.class);

    public static final void wireFellows(IdSpace idspace, Object controller) {
        new ConventionWire(controller).wireFellows(idspace);
    }

    public static final void wireFellows(IdSpace idspace, Object controller, char separator) {
        new ConventionWire(controller, separator).wireFellows(idspace);
    }

    public static final void wireFellows(IdSpace idspace, Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        new ConventionWire(controller, separator, ignoreZScript, ignoreXel).wireFellows(idspace);
    }

    public static final void wireVariables(Component comp, Object controller) {
        new ConventionWire(controller).wireVariables(comp);
    }

    public static final void wireVariables(Component comp, Object controller, char separator) {
        new ConventionWire(controller, separator).wireVariables(comp);
    }

    public static final void wireVariables(Component comp, Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        new ConventionWire(controller, separator, ignoreZScript, ignoreXel).wireVariables(comp);
    }

    public static final void wireVariables(Page page, Object controller) {
        new ConventionWire(controller).wireVariables(page);
    }

    public static final void wireVariables(Page page, Object controller, char separator) {
        new ConventionWire(controller, separator).wireVariables(page);
    }

    public static final void wireVariables(Page page, Object controller, char separator, boolean ignoreZScript, boolean ignoreXel) {
        new ConventionWire(controller, separator, ignoreZScript, ignoreXel).wireVariables(page);
    }

    public static final void wireController(Component comp, Object controller) {
        ConventionWires.wireController(comp, controller, '$');
    }

    public static final void wireController(Component comp, Object controller, char separator) {
        Object onm = comp.getAttribute("composerName");
        if (onm instanceof String && ((String)onm).length() > 0) {
            comp.setAttribute((String)onm, controller);
        } else {
            comp.setAttribute("_$composer$_", controller);
        }
        comp.setAttribute(separator + "composer", controller);
        String id = comp.getId();
        comp.setAttribute(id + separator + "composer", controller);
        comp.setAttribute(ConventionWires.composerNameByClass(id, controller.getClass(), separator), controller);
    }

    private static String composerNameByClass(String id, Class cls, char separator) {
        String clsname = cls.getName();
        int j = clsname.lastIndexOf(46);
        return id + separator + (j >= 0 ? clsname.substring(j + 1) : clsname);
    }

    public static final void wireImplicit(Component comp, Object controller) {
        new ConventionWire(controller, '$', true, true).wireImplicit(comp);
    }

    public static void addForwards(Component comp, Object controller) {
        ConventionWires.addForwards(comp, controller, '$');
    }

    public static void addForwards(Component comp, Object controller, char separator) {
        Class<?> cls = controller.getClass();
        Method[] mtds = cls.getMethods();
        block0: for (int j = 0; j < mtds.length; ++j) {
            Method md = mtds[j];
            String mdname = md.getName();
            if (mdname.length() < 5 || !Events.isValid(mdname)) continue;
            Component xcomp = comp;
            int k = 0;
            do {
                if ((k = mdname.lastIndexOf(separator)) < 3) continue;
                String srcevt = mdname.substring(0, k);
                if (k + 1 < mdname.length()) {
                    Page page;
                    String srccompid = mdname.substring(k + 1);
                    Object srccomp = xcomp.getAttributeOrFellow(srccompid, true);
                    if (srccomp == null && (page = xcomp.getPage()) != null) {
                        srccomp = page.getXelVariable(null, null, srccompid, true);
                    }
                    if (srccomp == null || !(srccomp instanceof Component)) {
                        if (!log.isDebugEnabled()) continue block0;
                        log.debug("Cannot find the associated component to forward event: " + mdname);
                        continue block0;
                    }
                    ((Component)srccomp).addForward(srcevt, xcomp, mdname);
                    xcomp = (Component)srccomp;
                    mdname = srcevt;
                    continue;
                }
                throw new UiException("Illegal event method name(component id not specified or consecutive '" + separator + "'): " + md.getName());
            } while (k >= 3);
        }
    }
}

