/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.jython;

import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.zkoss.zk.scripting.util.GenericInterpreter;
import org.zkoss.zk.ui.Page;

public class JythonInterpreter
extends GenericInterpreter {
    PythonInterpreter _ip;

    public void init(Page owner, String zslang) {
        super.init(owner, zslang);
        if (System.getProperty("python.home") == null) {
            System.setProperty("python.home", System.getProperty("java.io.tmpdir"));
        }
        PySystemState.initialize();
        PySystemState.add_extdir((String)owner.getDesktop().getWebApp().getRealPath("/WEB-INF/lib"), (boolean)true);
        PySystemState.add_classdir((String)owner.getDesktop().getWebApp().getRealPath("/WEB-INF/classes"));
        this._ip = new PythonInterpreter((PyObject)new Variables());
    }

    protected void exec(String script) {
        this._ip.exec(script);
    }

    public void destroy() {
        this._ip.cleanup();
        this._ip = null;
        super.destroy();
    }

    protected Object get(String name) {
        PyObject val = this._ip.get(name);
        return val != null ? Py.tojava((PyObject)val, Object.class) : null;
    }

    protected void set(String name, Object value) {
        if (value == null) {
            this._ip.set(name, (PyObject)null);
        } else {
            this._ip.set(name, value);
        }
    }

    protected void unset(String name) {
        this._ip.set(name, Py.None);
    }

    public Object getNativeInterpreter() {
        return this._ip;
    }

    private class Variables
    extends PyStringMap {
        private Variables() {
        }

        public synchronized PyObject __finditem__(String key) {
            Object val;
            PyObject pyo = super.__finditem__(key);
            if (pyo == null && (val = JythonInterpreter.this.getFromNamespace(key)) != GenericInterpreter.UNDEFINED) {
                return Py.java2py((Object)val);
            }
            return pyo;
        }
    }
}

