/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Library;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.XMLResourcesLocator;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.impl.DesktopImpl;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Composer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static XMLResourcesLocator _xmlloc;
    private static final String COMPONENT_INFO = "org.zkoss.zk.ui.metainfo.compinfo";

    public static boolean markClientInfoPerDesktop(Desktop desktop, String key) {
        return !(desktop instanceof DesktopImpl) || ((DesktopImpl)desktop).markClientInfoPerDesktop(key);
    }

    public static XMLResourcesLocator getXMLResourcesLocator() {
        if (_xmlloc == null) {
            String clsnm = Library.getProperty((String)"org.zkoss.zk.ui.sys.XMLResourcesLocator.class");
            if (clsnm != null) {
                try {
                    _xmlloc = (XMLResourcesLocator)Classes.newInstanceByThread((String)clsnm);
                    return _xmlloc;
                }
                catch (Throwable ex) {
                    log.warn("Unable to load " + clsnm, ex);
                }
            }
            _xmlloc = new ClassLocator();
        }
        return _xmlloc;
    }

    public static Composer newComposer(Page page, Object o) throws Exception {
        Class cls;
        if (o instanceof String) {
            String clsnm = ((String)o).trim();
            if (page != null) {
                return ((WebAppCtrl)((Object)page.getDesktop().getWebApp())).getUiFactory().newComposer(page, clsnm);
            }
            cls = Classes.forNameByThread((String)clsnm);
        } else if (o instanceof Class) {
            cls = (Class)o;
            if (page != null) {
                return ((WebAppCtrl)((Object)page.getDesktop().getWebApp())).getUiFactory().newComposer(page, cls);
            }
        } else {
            return (Composer)o;
        }
        return (Composer)cls.newInstance();
    }

    public static ComponentInfo getComponentInfo(Component comp) {
        Map<Component, ComponentInfo> map = Utils.getComponentInfos(false);
        return map != null ? map.get(comp) : null;
    }

    public static void setComponentInfo(Component comp, ComponentInfo info) {
        Map<Component, ComponentInfo> map = Utils.getComponentInfos(info != null);
        if (map != null) {
            if (info != null) {
                map.put(comp, info);
            } else {
                map.remove(comp);
            }
        }
    }

    private static Map<Component, ComponentInfo> getComponentInfos(boolean autoCreate) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            return null;
        }
        HashMap result = Generics.cast((Map)((Map)exec.getAttribute(COMPONENT_INFO)));
        if (result == null && autoCreate) {
            result = new HashMap();
            exec.setAttribute(COMPONENT_INFO, result);
        }
        return result;
    }
}

