/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.restlet.engine.io.ReadableSelectionChannel;
import org.restlet.engine.io.WakeupListener;
import org.restlet.ext.nio.internal.buffer.Buffer;
import org.restlet.ext.nio.internal.channel.BufferedSelectionChannel;
import org.restlet.ext.nio.internal.util.CompletionListener;

public class ReadableBufferedChannel
extends BufferedSelectionChannel<ReadableSelectionChannel>
implements ReadableSelectionChannel,
CompletionListener {
    private final CompletionListener completionListener;
    private volatile boolean endReached;

    public ReadableBufferedChannel(CompletionListener completionListener, Buffer buffer, ReadableSelectionChannel source, WakeupListener wakeupListener) {
        super(buffer, source, wakeupListener);
        this.completionListener = completionListener;
        this.endReached = false;
    }

    public boolean couldDrain(Buffer buffer, Object ... args) {
        return false;
    }

    @Override
    public boolean couldFill(Buffer buffer, Object ... args) {
        return !this.isEndReached();
    }

    private CompletionListener getCompletionListener() {
        return this.completionListener;
    }

    protected boolean isEndReached() {
        return this.endReached;
    }

    @Override
    public int onDrain(Buffer buffer, int maxDrained, Object ... args) throws IOException {
        return this.getBuffer().drain((ByteBuffer)args[0], maxDrained);
    }

    @Override
    public final int onFill(Buffer buffer, Object ... args) throws IOException {
        int result = this.getBuffer().fill((ReadableByteChannel)this.getWrappedChannel());
        if (result == -1) {
            this.setEndReached(true);
        }
        return result;
    }

    @Override
    public void onMessageCompleted(boolean eofDetected) throws IOException {
        if (this.getCompletionListener() != null) {
            this.getCompletionListener().onMessageCompleted(eofDetected);
        }
    }

    public int read(ByteBuffer targetBuffer) throws IOException {
        return this.getBuffer().process(this, 0, targetBuffer);
    }

    protected void setEndReached(boolean endReached) throws IOException {
        if (this.endReached != endReached) {
            this.endReached = endReached;
            if (this.endReached) {
                this.onMessageCompleted(false);
            }
        }
    }
}

