/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.ext.nio.internal.channel.WrapperChannel;
import org.restlet.ext.nio.internal.util.CompletionListener;

public class ReadableSizedChannel
extends WrapperChannel<ReadableByteChannel>
implements ReadableByteChannel {
    private volatile long availableSize;
    private volatile boolean endDetected;

    public ReadableSizedChannel(ReadableByteChannel source, long availableSize) {
        super(source);
        this.availableSize = availableSize;
        this.endDetected = false;
    }

    protected long getAvailableSize() {
        return this.availableSize;
    }

    protected boolean isEndDetected() {
        return this.endDetected;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int result = 0;
        if (this.getAvailableSize() > 0L) {
            if (this.getAvailableSize() < (long)dst.remaining()) {
                dst.limit((int)(this.getAvailableSize() + (long)dst.position()));
            }
            result = ((ReadableByteChannel)this.getWrappedChannel()).read(dst);
        } else {
            result = -1;
        }
        if (result > 0) {
            this.setAvailableSize(this.getAvailableSize() - (long)result);
            if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                Context.getCurrentLogger().finer("Bytes (read | available) : " + result + " | " + this.getAvailableSize());
            }
            if (this.getAvailableSize() == 0L && Context.getCurrentLogger().isLoggable(Level.FINER)) {
                Context.getCurrentLogger().finer("Channel fully read.");
            }
        } else if (result == -1) {
            this.setEndDetected(true);
        }
        return result;
    }

    protected void setAvailableSize(long availableSize) {
        this.availableSize = availableSize;
    }

    protected void setEndDetected(boolean endDetected) throws IOException {
        if (this.endDetected != endDetected) {
            this.endDetected = endDetected;
            if (endDetected && this.getWrappedChannel() instanceof CompletionListener) {
                ((CompletionListener)this.getWrappedChannel()).onMessageCompleted(this.isEndDetected());
            }
        }
    }
}

