/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.servlet;

import java.util.HashSet;
import javax.servlet.Servlet;
import org.osgi.service.http.HttpService;
import org.osgi.service.log.LogService;
import org.restlet.ext.osgi.ApplicationProvider;
import org.restlet.ext.servlet.ApplicationServlet;

public class RestletServletService {
    private HashSet<ApplicationProvider> applicationProviders = new HashSet();
    private HttpService httpService;
    private LogService logService;

    public void bindApplicationProvider(ApplicationProvider applicationProvider) {
        this.applicationProviders.add(applicationProvider);
        if (this.httpService != null) {
            this.registerServlet(applicationProvider);
        }
    }

    public void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
        for (ApplicationProvider applicationProvider : this.applicationProviders) {
            this.registerServlet(applicationProvider);
        }
    }

    public void bindLogService(LogService logService) {
        this.logService = logService;
    }

    private void registerServlet(ApplicationProvider applicationProvider) {
        block2: {
            ApplicationServlet servlet = new ApplicationServlet(applicationProvider);
            try {
                this.httpService.registerServlet(applicationProvider.getAlias(), (Servlet)servlet, applicationProvider.getInitParms(), applicationProvider.getContext());
            }
            catch (Exception e) {
                if (this.logService == null) break block2;
                this.logService.log(1, "Failed to register the application servlet at alias: '" + applicationProvider.getAlias() + "'", (Throwable)e);
            }
        }
    }

    public void unbindApplicationProvider(ApplicationProvider applicationProvider) {
        this.applicationProviders.remove(applicationProvider);
        if (this.httpService != null) {
            try {
                this.httpService.unregister(applicationProvider.getAlias());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void unbindHttpService(HttpService httpService) {
        if (this.httpService == httpService) {
            for (ApplicationProvider applicationProvider : this.applicationProviders) {
                try {
                    httpService.unregister(applicationProvider.getAlias());
                }
                catch (IllegalArgumentException e) {}
            }
            httpService = null;
        }
    }

    public void unbindLogService(LogService logService) {
        if (this.logService == logService) {
            this.logService = null;
        }
    }
}

