/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter.sys;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelArray;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.ListModelMap;
import org.zkoss.zul.ListModelSet;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.GroupsListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListModelConverter<C extends Component>
implements Converter<Object, Object, C>,
Serializable {
    private static final long serialVersionUID = 201108171744L;

    protected abstract ListModel<?> getComponentModel(C var1);

    protected ListModel<?> handleWrappedModel(BindContext ctx, C comp, ListModel<?> model) {
        return model;
    }

    @Override
    public Object coerceToUi(Object val, C comp, BindContext ctx) {
        if (val == null) {
            val = new ArrayList();
        }
        ListModelArray model = null;
        if (val instanceof ListModel) {
            BindELContext.addModel(comp, val);
            return val;
        }
        if (val instanceof Set) {
            model = new ListModelSet((Set)((Object)val), false);
        } else if (val instanceof List) {
            model = new ListModelList((List)val, false);
        } else if (val instanceof Map) {
            model = new ListModelMap((Map)((Object)val), false);
        } else if (val instanceof Object[]) {
            model = new ListModelArray((Object[])val, false);
        } else if (val instanceof Class && Enum.class.isAssignableFrom((Class)((Object)val))) {
            model = new ListModelArray((Object[])((Class)((Object)val)).getEnumConstants(), false);
        } else if (val instanceof GroupsModel) {
            model = GroupsListModel.toListModel((GroupsModel)((GroupsModel)val));
        } else {
            throw new UiException("Expects java.util.Set, java.util.List, java.util.Map, Object[], Enum Class, GroupsModel, or ListModel only. " + val.getClass());
        }
        ListModel<?> compModel = this.getComponentModel(comp);
        if (compModel instanceof Selectable) {
            Selectable selectable = (Selectable)compModel;
            ((Selectable)model).setMultiple(selectable.isMultiple());
            for (Object selected : selectable.getSelection()) {
                ((Selectable)model).addToSelection(selected);
            }
        }
        model = this.handleWrappedModel(ctx, comp, (ListModel<?>)model);
        BindELContext.addModel(comp, model);
        return model;
    }

    @Override
    public Object coerceToBean(Object val, C comp, BindContext ctx) {
        if (val == null) {
            throw new NullPointerException("value");
        }
        if (val instanceof ListModelSet) {
            return ((ListModelSet)val).getInnerSet();
        }
        if (val instanceof ListModelList) {
            return ((ListModelList)val).getInnerList();
        }
        if (val instanceof ListModelMap) {
            return ((ListModelMap)val).getInnerMap();
        }
        if (val instanceof ListModelArray) {
            return ((ListModelArray)val).getInnerArray();
        }
        if (val instanceof GroupsListModel) {
            return ((GroupsListModel)val).getGroupsModel();
        }
        if (val instanceof ListModel) {
            return val;
        }
        throw new UiException("Expects ListModelSet, ListModelList, ListModelMap, GroupsListModel or ListModel only." + val.getClass());
    }
}

