/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.Converter;
import org.zkoss.bind.converter.FormatedDateConverter;
import org.zkoss.bind.converter.FormatedNumberConverter;
import org.zkoss.bind.converter.ObjectBooleanConverter;
import org.zkoss.bind.converter.UriConverter;
import org.zkoss.bind.converter.sys.ChildrenBindingConverter;
import org.zkoss.lang.Classes;
import org.zkoss.zk.ui.UiException;

public class SystemConverters {
    private static final Logger _log = LoggerFactory.getLogger(SystemConverters.class);
    private static final Map<String, Converter> _converters = new HashMap<String, Converter>();
    private static boolean _init = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initBuiltinConverters() {
        Map<String, Converter> map = _converters;
        synchronized (map) {
            SystemConverters.set0("objectBoolean", new ObjectBooleanConverter());
            SystemConverters.set0("formatedDate", new FormatedDateConverter());
            SystemConverters.set0("formattedDate", new FormatedDateConverter());
            SystemConverters.set0("formatedNumber", new FormatedNumberConverter());
            SystemConverters.set0("formattedNumber", new FormatedNumberConverter());
            SystemConverters.set0("uri", new UriConverter());
            SystemConverters.set0("childrenBinding", new ChildrenBindingConverter());
            _init = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (_init) {
            return;
        }
        Map<String, Converter> map = _converters;
        synchronized (map) {
            if (_init) {
                return;
            }
            SystemConverters.initBuiltinConverters();
            _init = true;
        }
    }

    public static void set(String name, Converter converter) {
        SystemConverters.init();
        SystemConverters.set0(name, converter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void set0(String name, Converter converter) {
        if (_log.isDebugEnabled()) {
            _log.debug("set converter [{}]=[{}]", (Object)name, (Object)converter);
        }
        Map<String, Converter> map = _converters;
        synchronized (map) {
            _converters.put(name, converter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Converter get(String name) {
        Converter c;
        SystemConverters.init();
        Map<String, Converter> map = _converters;
        synchronized (map) {
            c = _converters.get(name);
        }
        if (c == null && name.indexOf(46) > 0) {
            try {
                c = (Converter)Classes.newInstanceByThread((String)name);
                SystemConverters.set(name, c);
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        return c;
    }
}

